/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.math.distributions.NormalDistribution;
import dr.util.DataTable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.FileReader;
import java.io.IOException;

public class MultidimensionalScalingLikelihood
extends AbstractModelLikelihood {
    public static final String MULTIDIMENSIONAL_SCALING_LIKELIHOOD = "multidimensionalScalingLikelihood";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String FILE_NAME = "fileName";
        public static final String TIP_TRAIT = "tipTrait";
        public static final String LOCATIONS = "locations";
        public static final String MDS_DIMENSION = "mdsDimension";
        public static final String MDS_PRECISION = "mdsPrecision";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileName", false, "The name of the file containing the assay table"), AttributeRule.newIntegerRule("mdsDimension", false, "The dimension of the space for MDS"), new ElementRule("locations", MatrixParameter.class), new ElementRule("mdsPrecision", Parameter.class)};

        @Override
        public String getParserName() {
            return MultidimensionalScalingLikelihood.MULTIDIMENSIONAL_SCALING_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DataTable<double[]> dataTable;
            String string = xMLObject.getStringAttribute(FILE_NAME);
            try {
                dataTable = DataTable.Double.parse(new FileReader(string));
            }
            catch (IOException iOException) {
                throw new XMLParseException("Unable to read assay data from file: " + iOException.getMessage());
            }
            if (dataTable.getRowCount() != dataTable.getColumnCount()) {
                throw new XMLParseException("Data table is not symmetrical.");
            }
            int n = xMLObject.getIntegerAttribute(MDS_DIMENSION);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(LOCATIONS);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(MDS_PRECISION);
            boolean bl = false;
            return new MultidimensionalScalingLikelihood(n, bl, parameter, matrixParameter, dataTable);
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of pairwise distance given vectors of coordinatesfor points according to the multidimensional scaling scheme of XXX & Rafferty (xxxx).";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultidimensionalScalingLikelihood.class;
        }
    };
    private int distanceCount;
    private int observationCount;
    private int upperThresholdCount;
    private int lowerThresholdCount;
    private int pointObservationCount;
    private int thresholdCount;
    private String[] locationLabels;
    private int locationCount;
    private double[] observations;
    private ObservationType[] observationTypes;
    private int[] rowLocationIndices;
    private int[] columnLocationIndices;
    private int[] upperThresholdIndices;
    private int[] lowerThresholdIndices;
    private int[] pointObservationIndices;
    private MatrixParameter locationsParameter;
    private Parameter mdsPrecisionParameter;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;
    protected boolean distancesKnown = false;
    private double sumOfSquaredResiduals;
    private double storedSumOfSquaredResiduals;
    private double[] distances;
    private double[] storedDistances;
    protected boolean[] locationUpdated;
    protected boolean[] distanceUpdated;
    protected boolean residualsKnown = false;
    protected boolean truncationsKnown = false;
    private double truncationSum;
    private double storedTruncationSum;
    private double[] truncations;
    private double[] storedTruncations;
    protected boolean thresholdsKnown = false;
    private double thresholdSum;
    private double storedThresholdSum;
    private double[] thresholds;
    private double[] storedThresholds;
    private boolean isLeftTruncated;
    private int mdsDimension;

    public MultidimensionalScalingLikelihood(String string) {
        super(string);
    }

    public MultidimensionalScalingLikelihood(int n, boolean bl, Parameter parameter, MatrixParameter matrixParameter, DataTable<double[]> dataTable) {
        super(MULTIDIMENSIONAL_SCALING_LIKELIHOOD);
        String[] stringArray = dataTable.getRowLabels();
        String[] stringArray2 = dataTable.getRowLabels();
        int n2 = dataTable.getRowCount();
        int n3 = (n2 - 1) * n2 / 2;
        double[] dArray = new double[n3];
        ObservationType[] observationTypeArray = new ObservationType[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = dataTable.getRow(i);
            int n5 = i + 1;
            while (n5 < n2) {
                dArray[n4] = dArray2[n5];
                observationTypeArray[n4] = ObservationType.POINT;
                nArray[n4] = i;
                nArray2[n4] = n5++;
                ++n4;
            }
        }
        this.initialize(n, bl, parameter, matrixParameter, stringArray, dArray, observationTypeArray, nArray, nArray2);
    }

    protected void initialize(int n, boolean bl, Parameter parameter, MatrixParameter matrixParameter, String[] stringArray, double[] dArray, ObservationType[] observationTypeArray, int[] nArray, int[] nArray2) {
        this.mdsDimension = n;
        this.locationCount = stringArray.length;
        this.distanceCount = this.locationCount * (this.locationCount - 1) / 2;
        this.locationLabels = stringArray;
        this.observations = dArray;
        this.observationTypes = observationTypeArray;
        this.rowLocationIndices = nArray;
        this.columnLocationIndices = nArray2;
        this.observationCount = dArray.length;
        this.upperThresholdCount = 0;
        this.lowerThresholdCount = 0;
        for (ObservationType observationType : observationTypeArray) {
            this.upperThresholdCount += observationType == ObservationType.UPPER_BOUND ? 1 : 0;
            this.lowerThresholdCount += observationType == ObservationType.LOWER_BOUND ? 1 : 0;
        }
        this.thresholdCount = this.upperThresholdCount + this.lowerThresholdCount;
        this.pointObservationCount = this.observationCount - this.thresholdCount;
        this.upperThresholdIndices = new int[this.upperThresholdCount];
        this.lowerThresholdIndices = new int[this.lowerThresholdCount];
        this.pointObservationIndices = new int[this.pointObservationCount];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block6: for (int i = 0; i < this.observationCount; ++i) {
            switch (observationTypeArray[i]) {
                case POINT: {
                    this.pointObservationIndices[n4] = i;
                    ++n4;
                    continue block6;
                }
                case UPPER_BOUND: {
                    this.upperThresholdIndices[n2] = i;
                    ++n2;
                    continue block6;
                }
                case LOWER_BOUND: {
                    this.lowerThresholdIndices[n3] = i;
                    ++n3;
                }
            }
        }
        this.locationsParameter = matrixParameter;
        this.setupLocationsParameter(this.locationsParameter);
        this.addVariable(matrixParameter);
        this.locationUpdated = new boolean[matrixParameter.getParameterCount()];
        this.distances = new double[this.distanceCount];
        this.storedDistances = new double[this.distanceCount];
        this.distanceUpdated = new boolean[this.distanceCount];
        this.truncations = new double[this.distanceCount];
        this.storedTruncations = new double[this.distanceCount];
        this.thresholds = new double[this.thresholdCount];
        this.storedThresholds = new double[this.thresholdCount];
        this.mdsPrecisionParameter = parameter;
        this.addVariable(parameter);
        this.isLeftTruncated = bl;
        this.makeDirty();
        this.addStatistic(new Distances());
    }

    protected void setupLocationsParameter(MatrixParameter matrixParameter) {
        int n;
        if (matrixParameter.getColumnDimension() > 0) {
            n = 1;
            if (matrixParameter.getColumnDimension() != this.locationCount) {
                System.err.println("locationsParameter column dimension (" + matrixParameter.getColumnDimension() + ") is not equal to the locationCount (" + this.locationCount + ")");
                n = 0;
            }
            if (matrixParameter.getRowDimension() != this.mdsDimension) {
                System.err.println("locationsParameter row dimension (" + matrixParameter.getRowDimension() + ") is not equal to the mdsDimension (" + this.mdsDimension + ")");
                n = 0;
            }
            if (n == 0) {
                System.exit(-1);
            }
        } else {
            matrixParameter.setColumnDimension(this.mdsDimension);
            matrixParameter.setRowDimension(this.locationCount);
        }
        for (n = 0; n < this.locationLabels.length; ++n) {
            matrixParameter.getParameter(n).setId(this.locationLabels[n]);
        }
        for (n = 0; n < matrixParameter.getParameterCount(); ++n) {
            Parameter parameter = matrixParameter.getParameter(n);
            try {
                if (parameter.getBounds() == null) continue;
            }
            catch (NullPointerException nullPointerException) {
                parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, parameter.getDimension()));
            }
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.locationsParameter) {
            int n2 = n / this.mdsDimension;
            this.locationUpdated[n2] = true;
            this.distancesKnown = false;
            this.residualsKnown = false;
            this.thresholdsKnown = false;
            this.truncationsKnown = false;
        } else if (variable == this.mdsPrecisionParameter) {
            for (int i = 0; i < this.distanceUpdated.length; ++i) {
                this.distanceUpdated[i] = true;
            }
            this.residualsKnown = false;
            this.thresholdsKnown = false;
            this.truncationsKnown = false;
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.distances, 0, this.storedDistances, 0, this.distances.length);
        System.arraycopy(this.truncations, 0, this.storedTruncations, 0, this.truncations.length);
        System.arraycopy(this.thresholds, 0, this.storedThresholds, 0, this.thresholds.length);
        this.storedLogLikelihood = this.logLikelihood;
        this.storedTruncationSum = this.truncationSum;
        this.storedThresholdSum = this.thresholdSum;
        this.storedSumOfSquaredResiduals = this.sumOfSquaredResiduals;
    }

    @Override
    protected void restoreState() {
        double[] dArray = this.storedDistances;
        this.storedDistances = this.distances;
        this.distances = dArray;
        this.distancesKnown = true;
        dArray = this.storedTruncations;
        this.storedTruncations = this.truncations;
        this.truncations = dArray;
        dArray = this.storedThresholds;
        this.storedThresholds = this.thresholds;
        this.thresholds = dArray;
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
        this.truncationSum = this.storedTruncationSum;
        this.truncationsKnown = true;
        this.thresholdSum = this.storedThresholdSum;
        this.thresholdsKnown = true;
        this.sumOfSquaredResiduals = this.storedSumOfSquaredResiduals;
        this.residualsKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void makeDirty() {
        int n;
        this.distancesKnown = false;
        this.likelihoodKnown = false;
        this.residualsKnown = false;
        this.truncationsKnown = false;
        this.thresholdsKnown = false;
        for (n = 0; n < this.locationUpdated.length; ++n) {
            this.locationUpdated[n] = true;
        }
        for (n = 0; n < this.distanceUpdated.length; ++n) {
            this.distanceUpdated[n] = true;
        }
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            int n;
            if (!this.distancesKnown) {
                this.calculateDistances();
                this.residualsKnown = false;
            }
            this.logLikelihood = this.computeLogLikelihood();
            for (n = 0; n < this.locationUpdated.length; ++n) {
                this.locationUpdated[n] = false;
            }
            for (n = 0; n < this.distanceUpdated.length; ++n) {
                this.distanceUpdated[n] = false;
            }
        }
        return this.logLikelihood;
    }

    protected double computeLogLikelihood() {
        double d = this.mdsPrecisionParameter.getParameterValue(0);
        if (!this.residualsKnown) {
            this.sumOfSquaredResiduals = this.calculateSumOfSquaredResiduals();
        }
        double d2 = 0.5 * Math.log(d) * (double)this.pointObservationCount - 0.5 * d * this.sumOfSquaredResiduals;
        if (this.thresholdCount > 0) {
            if (!this.thresholdsKnown) {
                this.thresholdSum = this.calculateThresholdObservations(d);
            }
            d2 += this.thresholdSum;
        }
        if (this.isLeftTruncated) {
            if (!this.truncationsKnown) {
                this.calculateTruncations(d);
            }
            this.truncationSum = this.calculateTruncationSum();
            d2 -= this.truncationSum;
        }
        this.likelihoodKnown = true;
        return d2;
    }

    protected double calculateThresholdObservations(double d) {
        int n;
        int n2;
        int n3;
        double d2 = 0.0;
        double d3 = 1.0 / Math.sqrt(d);
        int n4 = 0;
        for (n3 = 0; n3 < this.upperThresholdCount; ++n3) {
            double d4;
            n2 = this.upperThresholdIndices[n3];
            n = this.getDistanceIndexForObservation(n2);
            if (n != -1) {
                if (this.distanceUpdated[n]) {
                    d4 = NormalDistribution.tailCDF(this.observations[n2], this.distances[n], d3);
                    this.thresholds[n4] = Math.log(d4);
                }
            } else {
                d4 = NormalDistribution.tailCDF(this.observations[n2], 0.0, d3);
                this.thresholds[n4] = Math.log(d4);
            }
            if (Double.isInfinite(this.thresholds[n4])) {
                System.out.println("Error calculation threshold probability");
            }
            d2 += this.thresholds[n4];
            ++n4;
        }
        for (n3 = 0; n3 < this.lowerThresholdCount; ++n3) {
            n2 = this.lowerThresholdIndices[n3];
            n = this.getDistanceIndexForObservation(n2);
            if (n != -1) {
                if (this.distanceUpdated[n]) {
                    this.thresholds[n4] = NormalDistribution.cdf(this.observations[n2], this.distances[n], d3, true);
                }
            } else {
                this.thresholds[n4] = NormalDistribution.cdf(this.observations[n2], 0.0, d3, true);
            }
            if (Double.isInfinite(this.thresholds[n4])) {
                System.out.println("Error calculation threshold probability");
            }
            d2 += this.thresholds[n4];
            ++n4;
        }
        this.thresholdsKnown = true;
        return d2;
    }

    protected void calculateTruncations(double d) {
        double d2 = 1.0 / Math.sqrt(d);
        for (int i = 0; i < this.distanceCount; ++i) {
            if (!this.distanceUpdated[i]) continue;
            this.truncations[i] = NormalDistribution.cdf(this.distances[i], 0.0, d2, true);
        }
        this.truncationsKnown = true;
    }

    protected double calculateTruncationSum() {
        double d = 0.0;
        for (int i = 0; i < this.observationCount; ++i) {
            int n = this.getDistanceIndexForObservation(i);
            if (n != -1) {
                d += this.truncations[n];
                continue;
            }
            d += Math.log(0.5);
        }
        return d;
    }

    protected double calculateSumOfSquaredResiduals() {
        double d = 0.0;
        for (int i = 0; i < this.observationCount; ++i) {
            if (this.observationTypes[i] != ObservationType.POINT) continue;
            int n = this.getDistanceIndexForObservation(i);
            double d2 = n == -1 ? -this.observations[i] : this.distances[n] - this.observations[i];
            d += d2 * d2;
        }
        this.residualsKnown = true;
        return d;
    }

    protected void calculateDistances() {
        int n = 0;
        for (int i = 0; i < this.locationCount; ++i) {
            for (int j = i + 1; j < this.locationCount; ++j) {
                if (this.locationUpdated[i] || this.locationUpdated[j]) {
                    this.distances[n] = this.calculateDistance(this.locationsParameter.getParameter(i), this.locationsParameter.getParameter(j));
                    this.distanceUpdated[n] = true;
                }
                ++n;
            }
        }
        this.distancesKnown = true;
    }

    private int getDistanceIndexForObservation(int n) {
        int n2;
        int n3;
        int n4 = this.getLocationIndex(this.rowLocationIndices[n]);
        if (n4 == (n3 = this.getLocationIndex(this.columnLocationIndices[n]))) {
            return -1;
        }
        if (n4 > n3) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
        }
        n2 = 0;
        for (int i = 0; i < n4; ++i) {
            n2 += this.locationCount - i - 1;
        }
        return n2 += n3 - n4 - 1;
    }

    protected int getLocationIndex(int n) {
        return n;
    }

    public String[] getLocationLabels() {
        return this.locationLabels;
    }

    protected double calculateDistance(Parameter parameter, Parameter parameter2) {
        double d = 0.0;
        for (int i = 0; i < this.mdsDimension; ++i) {
            double d2 = parameter.getParameterValue(i) - parameter2.getParameterValue(i);
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public int getMDSDimension() {
        return this.mdsDimension;
    }

    public int getLocationCount() {
        return this.locationCount;
    }

    public MatrixParameter getLocationsParameter() {
        return this.locationsParameter;
    }

    public static enum ObservationType {
        POINT,
        UPPER_BOUND,
        LOWER_BOUND,
        MISSING;

    }

    public class Distances
    extends Statistic.Abstract {
        public Distances() {
            super("distances");
        }

        @Override
        public int getDimension() {
            return MultidimensionalScalingLikelihood.this.distanceCount;
        }

        @Override
        public double getStatisticValue(int n) {
            if (!MultidimensionalScalingLikelihood.this.distancesKnown) {
                MultidimensionalScalingLikelihood.this.calculateDistances();
            }
            return MultidimensionalScalingLikelihood.this.distances[n];
        }
    }
}

