/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evolution.datatype.ContinuousDataType;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.IntegerDataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel;
import dr.evomodel.bigfasttree.thorney.MutationBranchMap;
import dr.evomodel.bigfasttree.thorney.MutationList;
import dr.evomodel.tree.TreeModel;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class ConstrainedTreeBranchLengthProvider
extends MutationBranchMap.AbstractMutationBranchMap {
    public static final String CONSTRAINED_TREE_BRANCHLENGTH_PROVIDER = "ConstrainedTreeBranchMutationProvider";
    private final double[] cladeBranchLengths;
    private final double[] externalBranchLengths;
    private final double minBranchLength;
    private ConstrainedTreeModel constrainedTreeModel;

    public ConstrainedTreeBranchLengthProvider(ConstrainedTreeModel constrainedTreeModel, Tree tree, Double d, double d2, DataType dataType) {
        super(dataType);
        Object object;
        Serializable serializable;
        int n;
        boolean bl = !(dataType instanceof ContinuousDataType);
        this.minBranchLength = d2;
        this.constrainedTreeModel = constrainedTreeModel;
        this.externalBranchLengths = new double[tree.getExternalNodeCount()];
        this.cladeBranchLengths = new double[tree.getInternalNodeCount()];
        HashMap<String, NodeRef> hashMap = new HashMap<String, NodeRef>();
        for (n = 0; n < tree.getExternalNodeCount(); ++n) {
            serializable = tree.getExternalNode(n);
            hashMap.put(tree.getNodeTaxon((NodeRef)serializable).getId(), (NodeRef)serializable);
        }
        for (n = 0; n < constrainedTreeModel.getExternalNodeCount(); ++n) {
            serializable = constrainedTreeModel.getExternalNode(n);
            object = constrainedTreeModel.getNodeTaxon((NodeRef)serializable).getId();
            NodeRef nodeRef = (NodeRef)hashMap.get(object);
            this.externalBranchLengths[serializable.getNumber()] = bl ? (double)Math.round(tree.getBranchLength(nodeRef) * d) : tree.getBranchLength(nodeRef) * d;
        }
        HashMap<BitSet, NodeRef> hashMap2 = this.getBitSetNodeMap(tree, tree);
        serializable = this.getBitSetNodeMap(tree, constrainedTreeModel);
        object = new HashMap();
        for (Map.Entry object2 : hashMap2.entrySet()) {
            ((HashMap)object).put((NodeRef)object2.getValue(), (NodeRef)serializable.get(object2.getKey()));
        }
        for (int i = 0; i < tree.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getInternalNode(i);
            NodeRef nodeRef2 = (NodeRef)((HashMap)object).get(nodeRef);
            this.cladeBranchLengths[constrainedTreeModel.getSubtreeIndex((NodeRef)nodeRef2)] = bl ? (double)Math.round(tree.getBranchLength(nodeRef) * d) : tree.getBranchLength(nodeRef) * d;
        }
    }

    public ConstrainedTreeBranchLengthProvider(ConstrainedTreeModel constrainedTreeModel, Tree tree) {
        this(constrainedTreeModel, tree, 1.0, 0.0, IntegerDataType.INSTANCE);
    }

    public double getBranchLength(NodeRef nodeRef) {
        NodeRef nodeRef2;
        if (this.constrainedTreeModel.isExternal(nodeRef)) {
            return this.externalBranchLengths[nodeRef.getNumber()];
        }
        TreeModel treeModel = this.constrainedTreeModel.getSubtree(nodeRef);
        if (treeModel.isRoot(nodeRef2 = this.constrainedTreeModel.getNodeInSubtree(treeModel, nodeRef))) {
            int n = this.constrainedTreeModel.getSubtreeIndex(nodeRef);
            return this.cladeBranchLengths[n];
        }
        return this.minBranchLength;
    }

    @Override
    public MutationList getMutations(NodeRef nodeRef) {
        MutationList.SimpleMutationList simpleMutationList = new MutationList.SimpleMutationList(this.getBranchLength(nodeRef));
        return simpleMutationList;
    }

    private HashMap<BitSet, NodeRef> getBitSetNodeMap(Tree tree, Tree tree2) {
        HashMap<BitSet, NodeRef> hashMap = new HashMap<BitSet, NodeRef>();
        this.addBits(tree, tree2, tree2.getRoot(), hashMap);
        return hashMap;
    }

    private BitSet addBits(Tree tree, Tree tree2, NodeRef nodeRef, HashMap hashMap) {
        BitSet bitSet = new BitSet();
        if (tree2.isExternal(nodeRef)) {
            String string = tree2.getNodeTaxon(nodeRef).getId();
            bitSet.set(tree.getTaxonIndex(string));
        } else {
            for (int i = 0; i < tree2.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree2.getChild(nodeRef, i);
                bitSet.or(this.addBits(tree, tree2, nodeRef2, hashMap));
            }
        }
        hashMap.put(bitSet, nodeRef);
        return bitSet;
    }
}

