/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.BitSet;
import java.util.Set;

public class AncestralTaxonInTree
extends AbstractModel {
    private final Taxon ancestor;
    private final MutableTreeModel treeModel;
    private final TaxonList descendents;
    private final Set<Integer> tips;
    private final BitSet tipBitSet;
    private final Parameter pseudoBranchLength;
    private final Parameter height;
    private final double offset;
    private final boolean isAtRoot;
    private final boolean addTipHeightBound;
    private int index;
    private NodeRef node;
    private NodeRef tipNode;
    private int pathViaChildNumber = -1;
    private int storedIndex;
    private NodeRef storedNode;
    private NodeRef storedTipNodel;
    private int storedPathViaChildNumber;

    public AncestralTaxonInTree(Taxon taxon, MutableTreeModel mutableTreeModel, TaxonList taxonList, Parameter parameter, Parameter parameter2, NodeRef nodeRef, int n, double d, boolean bl, boolean bl2) throws TreeUtils.MissingTaxonException {
        super(taxon.getId());
        this.ancestor = taxon;
        this.treeModel = mutableTreeModel;
        this.descendents = taxonList;
        this.pseudoBranchLength = parameter;
        this.height = parameter2;
        this.offset = d;
        this.index = n;
        this.node = nodeRef;
        this.tips = TreeUtils.getTipsForTaxa(mutableTreeModel, taxonList);
        this.tipBitSet = TreeUtils.getTipsBitSetForTaxa(mutableTreeModel, taxonList);
        if (parameter != null) {
            this.addVariable(parameter);
        }
        if (parameter2 != null) {
            this.addVariable(parameter2);
        }
        this.isAtRoot = bl;
        this.addTipHeightBound = bl2;
    }

    public final double getPseudoBranchLength() {
        return this.pseudoBranchLength.getParameterValue(0);
    }

    public final double getHeight() {
        if (this.height != null) {
            return this.height.getParameterValue(0) + this.offset;
        }
        return 0.0;
    }

    public final boolean isOnAncestralPath() {
        return this.height != null;
    }

    public final boolean isAtRoot() {
        return this.isAtRoot;
    }

    public final boolean addTipHeightBound() {
        return this.addTipHeightBound;
    }

    public final NodeRef getTipNode() {
        return this.tipNode;
    }

    public final void setTipNode(NodeRef nodeRef) {
        this.tipNode = nodeRef;
    }

    final MutableTreeModel getTreeModel() {
        return this.treeModel;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final NodeRef getNode() {
        return this.node;
    }

    public final void setNode(NodeRef nodeRef) {
        this.node = nodeRef;
    }

    public final void setNode(NodeRef nodeRef, int n) {
        this.node = nodeRef;
        this.pathViaChildNumber = n;
    }

    public final int getPathChildNumber() {
        return this.pathViaChildNumber;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void storeState() {
        this.storedIndex = this.index;
        this.storedPathViaChildNumber = this.pathViaChildNumber;
        this.storedNode = this.node;
        this.storedTipNodel = this.tipNode;
    }

    @Override
    protected void restoreState() {
        this.index = this.storedIndex;
        this.pathViaChildNumber = this.storedPathViaChildNumber;
        this.node = this.storedNode;
        this.tipNode = this.storedTipNodel;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    public TaxonList getTaxonList() {
        return this.descendents;
    }

    public BitSet getTipBitSet() {
        return this.tipBitSet;
    }

    public Taxon getTaxon() {
        return this.ancestor;
    }
}

