/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.GeneralSubstitutionModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SVSGeneralSubstitutionModel
extends GeneralSubstitutionModel
implements Likelihood,
BayesianStochasticSearchVariableSelection,
Citable {
    private boolean isUsed = false;
    private double[] probability = null;
    private final Parameter indicatorsParameter;

    public SVSGeneralSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, Parameter parameter, Parameter parameter2) {
        super(string, dataType, frequencyModel, parameter, -1);
        if (parameter2 == null) {
            this.indicatorsParameter = new Parameter.Default(parameter.getDimension(), 1.0);
        } else {
            this.indicatorsParameter = parameter2;
            this.addVariable(parameter2);
        }
        this.setupIndicatorDimensionNames(-1);
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.ratesParameter.getParameterValue(i) * this.indicatorsParameter.getParameterValue(i);
        }
    }

    protected void setupIndicatorDimensionNames(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.indicatorsParameter.getParameterName();
        for (int i = 0; i < this.dataType.getStateCount(); ++i) {
            for (int j = i + 1; j < this.dataType.getStateCount(); ++j) {
                arrayList.add(this.getDimensionString(i, j, string));
            }
        }
        String[] stringArray = new String[]{};
        this.indicatorsParameter.setDimensionNames(arrayList.toArray(stringArray));
    }

    @Override
    public Parameter getIndicators() {
        return this.indicatorsParameter;
    }

    @Override
    public boolean validState() {
        return !this.updateMatrix || BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.ratesParameter && this.indicatorsParameter.getParameterValue(n) == 0.0) {
            return;
        }
        super.handleVariableChangedEvent(variable, n, changeType);
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (this.updateMatrix && !BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this)) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public boolean evaluateEarly() {
        return true;
    }

    @Override
    public void makeDirty() {
        this.updateMatrix = true;
    }

    @Override
    public String prettyName() {
        return "SVSGeneralSubstitutionModel-connectedness";
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public boolean isUsed() {
        return super.isUsed() && this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId())};
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Stochastic search variable selection, reversible substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2009_BAYESIAN);
    }

    protected class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return SVSGeneralSubstitutionModel.this.getLogLikelihood();
        }
    }
}

