/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

public enum DriftType {
    NONE("no drift"){

        @Override
        public void doSomeWork(int n) {
        }

        @Override
        public boolean hasDrift() {
            return false;
        }
    }
    ,
    SIMPLE("simple drift"){

        @Override
        public void doSomeWork(int n) {
        }
    }
    ,
    SCALAR("proportional shear with drift"){

        @Override
        public void doSomeWork(int n) {
        }

        @Override
        public int getShearSize(int n) {
            return 1;
        }
    }
    ,
    FULL("full shear matrix with drift"){

        @Override
        public void doSomeWork(int n) {
        }

        @Override
        public int getShearSize(int n) {
            return n * n;
        }
    };

    private String name;

    private DriftType(String string2) {
        this.name = string2;
    }

    public abstract void doSomeWork(int var1);

    public int getShearSize(int n) {
        return 0;
    }

    public boolean hasDrift() {
        return true;
    }

    public boolean hasShear(int n) {
        return this.getShearSize(n) != 0;
    }

    public String getName() {
        return this.name;
    }
}

