# Licensing Information for `CardioDataSets` Package

This package, `CardioDataSets`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **heartdisease_tbl_df**: 
  Originally heart_disease from the cheese package, licensed under MIT + file LICENSE. The dataset name has been changed to 'heartdisease_tbl_df' to indicate that this dataset is a tibble object.

- **hfPrevention_mtc_network**: 
  Originally hfPrevention from the gemtc package, licensed under GPL-3. The dataset name has been changed to 'hfPrevention_mtc_network' to indicate that this dataset is a mtc.network object.
  
- **cad_anticoagulants_df**: 
  Originally dat.anand1999 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'cad_anticoagulants_df' to indicate that this dataset is a data frame object.    

- **coronary_death_df**:
  Originally dat.cannon2006 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'coronary_death_df' to indicate that this dataset is a data frame object.

- **myocardialinfarction_df**: 
  Originally dat.lau1992 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'myocardialinfarction_df' to indicate that this dataset is a data frame object.   

- **emotion_heartrate_df**: 
  Originally data_emotion_heartrate from the esci package, licensed under GPL-3. The dataset name has been changed to 'emotion_heartrate_df' to indicate that this dataset is a data frame object.     

- **cardio_diabetes_tbl_df**: 
  Originally avandia from the openintro package, licensed under GPL-3. The dataset name has been changed to 'cardio_diabetes_tbl_df' to indicate that this dataset is a tibble object.   

- **cpr_survival_tbl_df**: 
  Originally cpr from the openintro package, licensed under GPL-3. The dataset name has been changed to 'cpr_survival_tbl_df' to indicate that this dataset is a tibble object.   

- **sulphinpyrazone_tbl_df**: 
  Originally sulphinpyrazone from the openintro package, licensed under GPL-3. The dataset name has been changed to 'sulphinpyrazone_tbl_df' to indicate that this dataset is a tibble object.   

- **ami_occurrences_tbl_df**: 
  Originally ami_occurrences from the openintro package, licensed under GPL-3. The dataset name has been changed to 'ami_occurrences_tbl_df' to indicate that this dataset is a tibble object.   

- **heartfailure_df**: 
  Originally HeartFailure from the survPen package, licensed under GPL-3 | file LICENSE. The dataset name has been changed to 'heartfailure_df' to indicate that this dataset is data frame object.   

- **cardiac_failure_df**: 
  Originally Heart from the SOPC package, licensed under MIT + file LICENSE. The dataset name has been changed to 'cardiac_failure_df' to indicate that this dataset is a data frame object.     

- **cardioRiskFactors_df**: 
  Originally CardioRiskFactors from the Rfit package, licensed under GPL (>= 2). The dataset name has been changed to 'cardioRiskFactors_df' to indicate that this dataset is a data frame object.  

- **cv_mortality_ts**: 
  Originally cmort from the astsa package, licensed under GPL (>= 2). The dataset name has been changed to 'cv_mortality_ts' to indicate that this dataset is a time series object.  

- **muscatine_coronary_risk_df**: 
  Originally muscatine from the geepack package, licensed under GPL (>= 3). The dataset name has been changed to 'muscatine_coronary_risk_df' to indicate that this dataset is a data frame object.  

- **statinMIrisk_df**: 
  Originally coronary from the RTSA package, licensed under GPL (>= 2). The dataset name has been changed to 'statinMIrisk_df' to indicate that this dataset is a data frame object.   

- **aortaDiss_tbl_df**: 
  Originally aortadis from the psfmi package, licensed under GPL (>= 2). The dataset name has been changed to 'aortaDiss_tbl_df' to indicate that this dataset is a tibble object.   

- **mriCardioVars_tbl_df**: 
  Originally mri from the rigr package, licensed under MIT + file LICENSE. The dataset name has been changed to 'mriCardioVars_tbl_df' to indicate that this dataset is a tibble object.   

- **usMortality_df**: 
  Originally USMortality from the lattice package, licensed under GPL (>= 2). The dataset name has been changed to 'usMortality_df' to indicate that this dataset is a data frame object.   

- **heart_transplant_df**: 
  Originally heart from the lrstat package, licensed under GPL (>= 2). The dataset name has been changed to 'heart_transplant_df' to indicate that this dataset is a data frame object.   

- **heartTransplantTime_tbl_df**: 
  Originally Artifici from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'heartTransplantTime_tbl_df' to indicate that this dataset is a tibble object.  

- **heartdiseaserisk_tbl_df**: 
  Originally heart from the Path.Analysis package, licensed under GPL-3. The dataset name has been changed to 'heartdiseaserisk_tbl_df' to indicate that this dataset is a tibble object.   

- **patient_CAV_df**: 
  Originally IDM_cav from the flexmsm package, licensed under MIT + file LICENSE. The dataset name has been changed to 'patient_CAV_df' to indicate that this dataset is a data frame object.  

- **cardiovascular_list**: 
  Originally cardiovascular from the bnma package, licensed under GPL-3. The dataset name has been changed to 'cardiovascular_list' to indicate that this dataset is a list object.   

- **betablockers_matrix**: 
  Originally betablocker500 from the MDDC package, licensed under GPL-3. The dataset name has been changed to 'betablockers_matrix' to indicate that this dataset is a matrix object.   

- **scottish_CVD_df**: 
  Originally cvd from the R2MLwiN package, licensed under GPL (>= 2). The dataset name has been changed to 'scottish_CVD_df' to indicate that this dataset is a data frame object.   

- **acs_patients_df**: 
  Originally acs from the moonBook package, licensed under GPL-2. The dataset name has been changed to 'acs_patients_df' to indicate that this dataset is a data frame object.  

- **age_heartrate_df**: 
  Originally heartrate from the UsingR package, licensed under GPL (>= 2). The dataset name has been changed to 'age_heartrate_df' to indicate that this dataset is a data frame object.   

- **radial_ivus_df**: 
  Originally radial from the moonBook package, licensed underGPL-2. The dataset name has been changed to 'radial_ivus_df' to indicate that this dataset is a data frame object.   

- **cardiac_gwas_df**: 
  Originally heartgenes214 from the getmstatistic package, licensed under MIT + file LICENSE. The dataset name has been changed to 'cardiac_gwas_df' to indicate that this dataset is a data frame object. 


## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `CardioDataSets`, is licensed under the GPL-3 License.
 
