/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.inference.distribution.SplineInterpolatedLikelihood;
import java.util.List;
import org.ohdsi.metaAnalysis.EmpiricalDataModel;

public class ExtendingEmpiricalDataModel
extends EmpiricalDataModel {
    public ExtendingEmpiricalDataModel(String fileName) {
        super(fileName);
    }

    public ExtendingEmpiricalDataModel() {
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> dataList) {
        return new SplineInterpolatedLikelihood(dataList, 1, false){
            private static final long serialVersionUID = 6586114515564784388L;

            public double logPDF(double x, EmpiricalDistributionData data) {
                int end = data.values.length - 1;
                if (end == 0) {
                    return data.density[0];
                }
                if (x <= data.values[0]) {
                    double slope = Math.max(0.0, (data.density[1] - data.density[0]) / (data.values[1] - data.values[0]));
                    return (x - data.values[0]) * slope + data.density[0];
                }
                if (x >= data.values[end]) {
                    double slope = Math.min(0.0, (data.density[end] - data.density[end - 1]) / (data.values[end] - data.values[end - 1]));
                    return (x - data.values[end]) * slope + data.density[end];
                }
                return super.logPDF(x, data);
            }

            public double gradientLogPdf(double x, EmpiricalDistributionData data) {
                int end = data.values.length - 1;
                if (x <= data.values[0]) {
                    return Math.max(0.0, (data.density[1] - data.density[0]) / (data.values[1] - data.values[0]));
                }
                if (x >= data.values[end]) {
                    return Math.min(0.0, (data.density[end] - data.density[end - 1]) / (data.values[end] - data.values[end - 1]));
                }
                return super.gradientLogPdf(x, data);
            }
        };
    }
}

