/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.PeriodicDummies;
import ec.tstoolkit.data.TrigonometricSeries;
import ec.tstoolkit.data.WindowType;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.eco.RobustCovarianceMatrixComputer;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;

public class CanovaHansenTest {
    private boolean lag1 = true;
    private Variables type = Variables.Dummy;
    protected ConcentratedLikelihood ll;
    private Matrix x;
    private Matrix cxe;
    private final RobustCovarianceMatrixComputer computer = new RobustCovarianceMatrixComputer();
    private DataBlock e;

    public boolean isLag1() {
        return this.lag1;
    }

    public void setLag1(boolean lag1) {
        this.lag1 = lag1;
    }

    public Variables getType() {
        return this.type;
    }

    public void setType(Variables type) {
        this.type = type;
    }

    public WindowType getWinType() {
        return this.computer.getWindowType();
    }

    public void setWinType(WindowType winType) {
        this.computer.setWindowType(winType);
    }

    public int getTruncationLag() {
        return this.computer.getTruncationLag();
    }

    public void setTruncationLag(int truncationLag) {
        this.computer.setTruncationLag(truncationLag);
    }

    public Matrix getXe() {
        return this.computer.getXe();
    }

    public Matrix getX() {
        return this.x;
    }

    public Matrix getOmega() {
        return this.computer.getRobustCovariance();
    }

    public Matrix getRobustCovariance() {
        return this.computer.getRobustCovariance();
    }

    public DataBlock getE() {
        return this.e;
    }

    public void setX(Matrix x) {
        this.x = x;
    }

    public ConcentratedLikelihood getLikelihood() {
        return this.ll;
    }

    public boolean process(IReadDataBlock s) {
        if (this.type != Variables.UserDefined) {
            return false;
        }
        return this.process(s, 0, 0);
    }

    public boolean process(IReadDataBlock s, int period, int startpos) {
        DataBlock y = new DataBlock(s);
        RegModel model = new RegModel();
        if (this.lag1) {
            model.addX(y.drop(0, 1));
            y = y.drop(1, 0);
            ++startpos;
        }
        switch (this.type.ordinal()) {
            case 0: {
                Object vars = new PeriodicDummies(period, startpos);
                this.x = ((PeriodicDummies)vars).matrix(y.getLength());
                break;
            }
            case 1: {
                Object vars = TrigonometricSeries.regular(period);
                this.x = ((TrigonometricSeries)vars).matrix(y.getLength());
                model.setMeanCorrection(true);
                break;
            }
            default: {
                model.setMeanCorrection(true);
            }
        }
        model.setY(y);
        if (this.x == null) {
            return false;
        }
        for (int i = 0; i < this.x.getColumnsCount(); ++i) {
            model.addX(this.x.column(i));
        }
        Ols ols = new Ols();
        ols.process(model);
        this.ll = ols.getLikelihood();
        this.e = ols.getResiduals();
        this.computer.compute(this.x.all(), this.e);
        this.cxe = this.computer.getXe().clone();
        for (int i = 0; i < this.x.getColumnsCount(); ++i) {
            this.cxe.column(i).cumul();
        }
        return true;
    }

    public double test(int var) {
        return this.computeStat(this.computer.getOmega().subMatrix(var, var + 1, var, var + 1), this.cxe.subMatrix(0, -1, var, var + 1));
    }

    public double test(int var, int nvars) {
        return this.computeStat(this.computer.getOmega().subMatrix(var, var + nvars, var, var + nvars), this.cxe.subMatrix(0, -1, var, var + nvars));
    }

    public double testAll() {
        return this.computeStat(this.computer.getOmega().all(), this.cxe.all());
    }

    public double robustTestCoefficients() {
        Matrix rcov = this.computer.getRobustCovariance().clone();
        SymmetricMatrix.lcholesky(rcov);
        double[] tmp = (double[])this.ll.getB().clone();
        DataBlock b = new DataBlock(tmp, tmp.length - rcov.getRowsCount(), tmp.length, 1);
        LowerTriangularMatrix.rsolve(rcov, b);
        double f = b.ssq() / (double)this.x.getColumnsCount();
        F ftest = new F();
        ftest.setDFNum(b.getLength());
        ftest.setDFDenom(this.x.getRowsCount());
        return ftest.getProbability(f, ProbabilityType.Upper);
    }

    public double olsTestCoefficients() {
        Matrix rcov = this.ll.getBVar().clone();
        SymmetricMatrix.lcholesky(rcov);
        double[] tmp = (double[])this.ll.getB().clone();
        DataBlock b = new DataBlock(tmp, 1, tmp.length, 1);
        LowerTriangularMatrix.rsolve(rcov, b);
        double f = b.ssq() / (double)this.x.getColumnsCount();
        F ftest = new F();
        ftest.setDFNum(b.getLength());
        ftest.setDFDenom(this.x.getRowsCount());
        return ftest.getProbability(f, ProbabilityType.Upper);
    }

    private double computeStat(SubMatrix O, SubMatrix cx) {
        int n = cx.getRowsCount();
        int nx = cx.getColumnsCount();
        Matrix FF = Matrix.square(nx);
        for (int i = 0; i < n; ++i) {
            FF.addXaXt(1.0, cx.row(i));
        }
        Matrix sig = new Matrix(O);
        SymmetricMatrix.lcholesky(sig);
        LowerTriangularMatrix.rsolve(sig, FF.all());
        LowerTriangularMatrix.lsolve(sig, FF.all().transpose());
        double tr = FF.diagonal().sum();
        return tr / (double)(n * n);
    }

    public static enum Variables {
        Dummy,
        Trigonometric,
        UserDefined;

    }
}

