/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Clas.algorithm.classification;

import java.util.List;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.IClassifier;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.classification.softmax.ClassificationProblemEvaluator;
import keel.Algorithms.Neural_Networks.NNEP_Clas.problem.errorfunctions.ClassificationAccuracyErrorFunction;
import keel.Algorithms.Neural_Networks.NNEP_Common.algorithm.NeuralNetAlgorithm;
import net.sf.jclec.IEvaluator;
import net.sf.jclec.base.AbstractIndividual;

public class CCRElitistNeuralNetAlgorithm<I extends AbstractIndividual<IClassifier>>
extends NeuralNetAlgorithm<I> {
    private static final long serialVersionUID = 7315342480632585002L;
    protected I bestCCRIndividual;
    private ClassificationAccuracyErrorFunction caErrorFunction = new ClassificationAccuracyErrorFunction();

    public I getBestCCRIndividual() {
        return this.bestCCRIndividual;
    }

    @Override
    public void doInit() {
        super.doInit();
        this.bestCCRIndividual = (AbstractIndividual)this.obtainBestClassifier(this.bset.subList(0, this.nofselSecondMutator), this.evaluator).copy();
    }

    @Override
    protected void doUpdate() {
        super.doUpdate();
        this.bset.add(1, this.bestCCRIndividual);
        this.bset.remove(this.populationSize - 1);
        this.bestCCRIndividual = (AbstractIndividual)this.obtainBestClassifier(this.bset.subList(0, this.nofselSecondMutator), this.evaluator).copy();
    }

    protected I obtainBestClassifier(List<I> individuals, IEvaluator evaluator) {
        if (evaluator instanceof ClassificationProblemEvaluator) {
            ClassificationProblemEvaluator clEvaluator = (ClassificationProblemEvaluator)evaluator;
            AbstractIndividual best = null;
            double bestCCR = 0.0;
            for (int i = 0; i < individuals.size(); ++i) {
                AbstractIndividual individual = (AbstractIndividual)individuals.get(i);
                IClassifier classifier = (IClassifier)individual.getGenotype();
                double CCR = clEvaluator.getTrainClassificationError(classifier, this.caErrorFunction);
                if (i != 0 && !(CCR >= bestCCR)) continue;
                best = individual;
                bestCCR = CCR;
            }
            return (I)best;
        }
        return null;
    }
}

