/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.SADE;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class SADEGenerator
extends PrototypeGenerator {
    private int k;
    private int PopulationSize;
    private double ParticleSize;
    private int MaxIter;
    private double ScalingFactor;
    private double[] CrossOverRate;
    private int LearningPeriod;
    private int Strategy;
    protected int numberOfPrototypes;
    protected int numberOfStrategies;
    protected int numberOfClass;
    private String[] paramsOfInitialReducction = null;

    public SADEGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones) {
        super(_trainingDataSet);
        this.algorithmName = "SADE";
        this.k = neigbors;
        this.PopulationSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
    }

    public SADEGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "SADE";
        this.k = parameters.getNextAsInt();
        this.PopulationSize = parameters.getNextAsInt();
        this.ParticleSize = parameters.getNextAsDouble();
        this.MaxIter = parameters.getNextAsInt();
        this.LearningPeriod = parameters.getNextAsInt();
        this.numberOfStrategies = parameters.getNextAsInt();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.PopulationSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " LP=  " + this.LearningPeriod + "\n");
    }

    public PrototypeSet mutant(PrototypeSet[] population, int actual, int mejor) {
        PrototypeSet mutant = new PrototypeSet(population.length);
        int[] lista = new int[population.length];
        this.inic_vector_sin(lista, actual);
        this.desordenar_vector_sin(lista);
        PrototypeSet r1 = population[lista[0]];
        PrototypeSet r2 = population[lista[1]];
        PrototypeSet r3 = population[lista[2]];
        PrototypeSet r4 = population[lista[3]];
        PrototypeSet r5 = population[lista[4]];
        switch (this.Strategy) {
            case 1: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                mutant = producto.sumar(r1);
                break;
            }
            case 2: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet resta2 = r4.restar(r5);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = r1.sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 3: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet resta3 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet producto3 = resta3.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[actual].sumar(producto);
                result = result.sumar(producto2);
                mutant = result.sumar(producto3);
                break;
            }
            case 4: {
                PrototypeSet resta = r1.restar(population[actual]);
                PrototypeSet resta2 = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(RandomGenerator.Randdouble(0.0, 1.0));
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[actual].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 5: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                mutant = population[mejor].sumar(producto);
                break;
            }
            case 6: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[actual].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 7: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[mejor].sumar(producto);
                mutant = result.sumar(producto2);
            }
        }
        mutant.applyThresholds();
        return mutant;
    }

    public double Skg(int strategy, int[][] successRate, int[][] failureRate) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (int k = 0; k < this.LearningPeriod; ++k) {
            numerator += (double)successRate[k][strategy];
            denominator += (double)(successRate[k][strategy] + failureRate[k][strategy]);
        }
        double SKG = numerator / denominator + 0.01;
        return SKG;
    }

    public double updateProbability(int strategy, int[][] successRate, int[][] failureRate) {
        double numerator = 0.0;
        double denominator = 0.0;
        numerator = this.Skg(strategy, successRate, failureRate);
        for (int i = 0; i < this.numberOfStrategies; ++i) {
            denominator += this.Skg(i, successRate, failureRate);
        }
        return numerator / denominator;
    }

    public int selectStrategy(double[] ProbabilityStrategy) {
        double random = RandomGenerator.Randdouble(0.0, 1.0);
        double aux = 0.0;
        boolean end = false;
        int selected = 1;
        for (int i = 0; i < this.numberOfStrategies && !end; ++i) {
            if (!(random <= (aux += ProbabilityStrategy[i]))) continue;
            selected = i + 1;
            end = true;
        }
        return selected;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet nominalPopulation;
        int i;
        int j;
        int i2;
        int i3;
        System.out.print("\nThe algorithm  SADE is starting...\n Computing...\n");
        System.out.println("Number of prototypes, result set = " + this.numberOfPrototypes + "\n");
        if (this.numberOfPrototypes < this.trainingDataSet.getPosibleValuesOfOutput().size()) {
            System.out.println("Number of prototypes less than the number of clases");
            this.numberOfPrototypes = this.trainingDataSet.getPosibleValuesOfOutput().size();
        }
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        PrototypeSet[] population = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] mutation = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] crossover = new PrototypeSet[this.PopulationSize];
        int kStrategies = this.numberOfStrategies;
        double[] ProbabilityStrategy = new double[kStrategies];
        double[] CRmk = new double[kStrategies];
        double[][] CRmemory = new double[this.LearningPeriod][];
        double CRm = 0.5;
        int[][] successRate = new int[this.LearningPeriod][];
        int[][] failureRate = new int[this.LearningPeriod][];
        for (i3 = 0; i3 < this.LearningPeriod; ++i3) {
            successRate[i3] = new int[kStrategies];
            failureRate[i3] = new int[kStrategies];
            CRmemory[i3] = new double[kStrategies];
            for (int j2 = 0; j2 < kStrategies; ++j2) {
                successRate[i3][j2] = 1;
                failureRate[i3][j2] = 1;
                CRmemory[i3][j2] = 0.5;
            }
        }
        for (i3 = 0; i3 < ProbabilityStrategy.length; ++i3) {
            ProbabilityStrategy[i3] = 1.0 / (double)kStrategies;
            CRmk[i3] = 0.5;
        }
        this.CrossOverRate = new double[this.numberOfStrategies];
        double[] F = new double[this.PopulationSize];
        double[] fitness = new double[this.PopulationSize];
        double[] fitness_bestPopulation = new double[this.PopulationSize];
        PrototypeSet bestParticle = new PrototypeSet();
        population[0] = this.selecRandomSet(this.numberOfPrototypes, true).clone();
        fitness[0] = SADEGenerator.accuracy(population[0], this.trainingDataSet);
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (i2 = 0; i2 < this.numberOfClass; ++i2) {
            clases[i2] = new PrototypeSet(this.trainingDataSet.getFromClass(i2));
        }
        for (i2 = 0; i2 < population[0].size(); ++i2) {
            for (j = 0; j < this.numberOfClass; ++j) {
                if (population[0].getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                population[0].add(clases[j].getRandom());
            }
        }
        for (i2 = 1; i2 < this.PopulationSize; ++i2) {
            population[i2] = new PrototypeSet();
            for (j = 0; j < population[0].size(); ++j) {
                population[i2].add(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
            }
            fitness[i2] = SADEGenerator.accuracy(population[i2], this.trainingDataSet);
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (int i4 = 1; i4 < this.PopulationSize; ++i4) {
            if (!(fitness[i4] > bestFitness)) continue;
            bestFitness = fitness[i4];
            bestFitnessIndex = i4;
        }
        for (int j3 = 0; j3 < this.PopulationSize; ++j3) {
            for (i = 0; i < population[j3].size(); ++i) {
                ((Prototype)population[j3].get(i)).setIndex(i);
            }
        }
        for (int iter = 1; iter <= this.MaxIter; ++iter) {
            int k;
            if (iter % this.LearningPeriod == 0) {
                for (k = 0; k < kStrategies; ++k) {
                    ProbabilityStrategy[k] = this.updateProbability(k, successRate, failureRate);
                    successRate[iter % this.LearningPeriod][k] = 0;
                    failureRate[iter % this.LearningPeriod][k] = 0;
                }
            }
            for (i = 0; i < this.PopulationSize; ++i) {
                F[i] = RandomGenerator.RandGaussian() * 0.3 + 0.5;
            }
            if (iter % this.LearningPeriod == 0) {
                k = 0;
                while (k < this.numberOfStrategies) {
                    CRmk[k] = 0.0;
                    for (int m = 0; m < this.LearningPeriod; ++m) {
                        int n = k;
                        CRmk[n] = CRmk[n] + CRmemory[m][k];
                    }
                    int n = k++;
                    CRmk[n] = CRmk[n] / (double)this.LearningPeriod;
                }
            }
            for (k = 0; k < this.numberOfStrategies; ++k) {
                this.CrossOverRate[k] = RandomGenerator.RandGaussian() * 0.1 + CRmk[k];
                while (this.CrossOverRate[k] < 0.0 || this.CrossOverRate[k] > 1.0) {
                    this.CrossOverRate[k] = RandomGenerator.RandGaussian() * 0.1 + CRmk[k];
                }
            }
            for (i = 0; i < this.PopulationSize; ++i) {
                this.Strategy = this.selectStrategy(ProbabilityStrategy);
                this.ScalingFactor = F[i];
                mutation[i] = new PrototypeSet(population[i].size());
                mutation[i] = this.mutant(population, i, bestFitnessIndex).clone();
                crossover[i] = new PrototypeSet(population[i]);
                if (this.Strategy != 4) {
                    for (int j4 = 0; j4 < population[i].size(); ++j4) {
                        double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
                        if (!(randNumber < this.CrossOverRate[this.Strategy - 1])) continue;
                        crossover[i] = mutation[i].clone();
                    }
                } else {
                    crossover[i] = mutation[i].clone();
                }
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i]);
                fitness[i] = SADEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(crossover[i]);
                double trialVector = SADEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                if (trialVector > fitness[i]) {
                    int[] nArray = successRate[iter % this.LearningPeriod];
                    int n = this.Strategy - 1;
                    nArray[n] = nArray[n] + 1;
                    CRmemory[iter % this.LearningPeriod][this.Strategy - 1] = this.CrossOverRate[this.Strategy - 1];
                    population[i] = crossover[i].clone();
                    fitness[i] = trialVector;
                } else {
                    int[] nArray = failureRate[iter % this.LearningPeriod];
                    int n = this.Strategy - 1;
                    nArray[n] = nArray[n] + 1;
                }
                if (!(fitness[i] > bestFitness)) continue;
                bestFitness = fitness[i];
                bestFitnessIndex = i;
                System.out.println("Iter=" + iter + " Acc= " + bestFitness);
            }
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[bestFitnessIndex]);
        System.err.println("\n% de acierto en training Nominal " + (double)KNN.classficationAccuracy(nominalPopulation, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("SADE", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        SADEGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        SADEGenerator generator = new SADEGenerator(training, k, swarm, particle, iter);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

