
# SSP 1.1.0

## Function adjustments

- `simdata()` now includes the new `jitter.base` parameter, which allows
  controlled stochastic perturbations of site-level parameters. This
  feature increases variability among simulated communities,
  particularly in nested designs (e.g., sites within regions), where
  previous versions tended to generate unrealistically similar
  communities. By applying mild randomness to occurrence and abundance
  probabilities, `simdata()` produces simulated data sets with
  multivariate dispersion closer to empirical expectations.

- The use of `jitter.base` is optional (default `jitter.base = 0`), so
  existing workflows remain unchanged. Users who wish to reproduce the
  behavior of earlier versions can simply ignore this parameter. For
  reproducibility, remember to use `set.seed()` before calling
  `simdata()`.

# SSP 1.0.2 (2025-04-23)

## Changes requested by CRAN

- Updated cross-references in `.Rd` files to use explicit package
  anchors (e.g., `\link[ggplot2:ggplot2-package]{ggplot2}`) as requested
  by the CRAN team.
- Removed all `\link{}` usages without package anchors in documentation
  files.
- Ensured compatibility with HTML reference manuals.

## Documentation improvements

- All .Rd documentation files were migrated to the **roxygen2** format.
- Improved consistency and accuracy in the documentation of function
  arguments and outputs.
- Added missing imports in the NAMESPACE to fix visibility issues
  (`ggplot`, `geom_point`, `specnumber`, etc.).
- Removed unused `@importFrom` tags and documented only necessary
  dependencies.

## Code adjustments

- Replaced use of `rel()` in `plot_ssp()` to avoid dependency on
  `grid::rel`, which is not exported.
- Reformatted long lines in examples to comply with CRAN’s 100-character
  limit.

## Testing and validation

- `devtools::check()` returns **0 errors \| 0 warnings \| 1 notes**
  (only minor ones related to timestamp verification).
