/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.EuclideanDistance;
import cc.mallet.types.InfiniteDistance;
import cc.mallet.types.ManhattenDistance;
import cc.mallet.types.Metric;
import cc.mallet.types.SparseVector;

public class Minkowski
implements Metric {
    double q;
    double oneOverQ;

    public Minkowski(double q) {
        this.q = q;
        this.oneOverQ = 1.0 / q;
    }

    public static Metric getMetric(double q) {
        if (q == 1.0) {
            return new ManhattenDistance();
        }
        if (q == 2.0) {
            return new EuclideanDistance();
        }
        if (q == Double.POSITIVE_INFINITY) {
            return new InfiniteDistance();
        }
        return new Minkowski(q);
    }

    @Override
    public double distance(SparseVector a, SparseVector b) {
        double diff;
        double dist = 0.0;
        if (a == null || b == null) {
            throw new IllegalArgumentException("Distance from a null vector is undefined.");
        }
        int leftLength = a.numLocations();
        int rightLength = b.numLocations();
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < leftLength && rightIndex < rightLength) {
            int rightFeature;
            int leftFeature = a.indexAtLocation(leftIndex);
            if (leftFeature < (rightFeature = b.indexAtLocation(rightIndex))) {
                diff = Math.abs(a.valueAtLocation(leftIndex));
                ++leftIndex;
            } else if (leftFeature == rightFeature) {
                diff = Math.abs(a.valueAtLocation(leftIndex) - b.valueAtLocation(rightIndex));
                ++leftIndex;
                ++rightIndex;
            } else {
                diff = Math.abs(b.valueAtLocation(rightIndex));
                ++rightIndex;
            }
            dist += Math.pow(diff, this.q);
        }
        while (leftIndex < leftLength) {
            diff = Math.abs(a.valueAtLocation(leftIndex));
            dist += Math.pow(diff, this.q);
            ++leftIndex;
        }
        while (rightIndex < rightLength) {
            diff = Math.abs(b.valueAtLocation(rightIndex));
            dist += Math.pow(diff, this.q);
            ++rightIndex;
        }
        return Math.pow(dist, this.oneOverQ);
    }
}

