/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.utils;

import eu.kliegr.ac1.EvaluateCrossvalidationConfig;
import eu.kliegr.ac1.rule.parsers.GUHASimplifiedParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class EvaluateCrossvalidation {
    private static final Logger LOGGER = Logger.getLogger(GUHASimplifiedParser.class.getName());

    public static void evaluateCrossvalidation(EvaluateCrossvalidationConfig config) throws FileNotFoundException, IOException {
        File[] files;
        File dir = new File(config.getEvaluationDir());
        double totalAccuracy = 0.0;
        int fileCount = 0;
        for (File f : files = dir.listFiles()) {
            Stream<String> lines;
            Optional<String> accuracyS;
            if (!f.getName().matches(config.getFilePattern()) || !(accuracyS = (lines = Files.lines(Paths.get(f.getAbsolutePath(), new String[0]))).filter(line -> line.startsWith("Accuracy:")).findFirst().map(line -> line.substring("Accuracy:".length()))).isPresent()) continue;
            totalAccuracy += Double.parseDouble(accuracyS.get());
            ++fileCount;
        }
        PrintStream outputFile = new PrintStream(new FileOutputStream(config.getOutputPath()));
        LOGGER.log(Level.INFO, "Files matched {0}", fileCount);
        LOGGER.info(String.valueOf(totalAccuracy / (double)fileCount));
        outputFile.append(config.getFilePattern() + "," + totalAccuracy / (double)fileCount + "," + fileCount + "\n");
    }

    private EvaluateCrossvalidation() {
    }
}

