/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealRange;

public class RealRangeArray
implements Iterable<RealRange> {
    private static final PrintStream SYSOUT = System.out;
    private List<RealRange> rangeList;
    private RealRange.Direction direction;

    public RealRangeArray() {
        this.init();
    }

    public RealRangeArray(RealRangeArray array) {
        this();
        if (array != null && array.rangeList != null) {
            for (RealRange range : array.rangeList) {
                this.add(new RealRange(range));
            }
        }
    }

    public RealRangeArray(List<Real2Range> r2rList, RealRange.Direction dir) {
        this.init();
        for (Real2Range r2r : r2rList) {
            RealRange range = RealRange.Direction.HORIZONTAL.equals((Object)dir) ? r2r.getXRange() : r2r.getYRange();
            this.add(range);
        }
        this.direction = dir;
    }

    public RealRangeArray(List<RealRange> rangeList) {
        this.rangeList = rangeList;
    }

    public RealRangeArray(Real2Range textBox, RealRange.Direction direction) {
        RealRange range = textBox.getRealRange(direction);
        this.add(range);
    }

    private void init() {
        this.rangeList = new ArrayList<RealRange>();
    }

    public void add(RealRange range) {
        if (range != null && this.rangeList != null) {
            this.rangeList.add(range);
        }
    }

    public void sort() {
        Collections.sort(this.rangeList);
    }

    public void sortAndRemoveOverlapping() {
        this.sort();
        ArrayList<RealRange> newList = new ArrayList<RealRange>();
        Iterator<RealRange> iterator = this.rangeList.iterator();
        RealRange lastRange = null;
        while (iterator.hasNext()) {
            RealRange range = iterator.next();
            if (lastRange == null) {
                newList.add(range);
                lastRange = range;
                continue;
            }
            boolean intersects = lastRange.intersectsWith(range);
            if (intersects) {
                RealRange merged = lastRange.plus(range);
                newList.set(newList.size() - 1, merged);
                lastRange = merged;
                continue;
            }
            newList.add(range);
            lastRange = range;
        }
        this.rangeList = newList;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RealRangeArray)) {
            return false;
        }
        RealRangeArray array2 = (RealRangeArray)obj;
        if (this.size() != array2.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(array2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 17;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            h += this.rangeList.get(i).hashCode() * 31;
        }
        return h;
    }

    public int size() {
        return this.rangeList.size();
    }

    public RealRange get(int serial) {
        return this.rangeList.get(serial);
    }

    public void debug() {
        for (RealRange range : this.rangeList) {
            SYSOUT.println(range);
        }
    }

    public RealRangeArray plus(RealRangeArray array) {
        RealRangeArray newArray = null;
        if (array != null) {
            newArray = new RealRangeArray();
            for (RealRange realRange : this.rangeList) {
                newArray.add(new RealRange(realRange));
            }
            for (RealRange realRange : array.rangeList) {
                newArray.add(new RealRange(realRange));
            }
            newArray.sortAndRemoveOverlapping();
        }
        return newArray;
    }

    public RealRangeArray inverse() {
        RealRangeArray newArray = null;
        RealRangeArray copy = new RealRangeArray(this);
        copy.sortAndRemoveOverlapping();
        if (copy.size() > 0) {
            newArray = new RealRangeArray();
            RealRange last = null;
            for (RealRange current : copy) {
                if (last != null) {
                    RealRange gap = new RealRange(last.maxval, current.minval);
                    newArray.add(gap);
                }
                last = current;
            }
        }
        return newArray;
    }

    @Override
    public Iterator<RealRange> iterator() {
        return this.rangeList.iterator();
    }

    public void addCaps(Real2Range r2r) {
        if (this.direction == null) {
            throw new RuntimeException("Must give direction");
        }
        this.addCaps(r2r, this.direction);
    }

    public void addCaps(Real2Range r2r, RealRange.Direction dir) {
        if (this.direction == null) {
            this.direction = dir;
        } else if (this.direction != dir) {
            throw new RuntimeException("Cannot change direction");
        }
        RealRange range = RealRange.Direction.HORIZONTAL.equals((Object)dir) ? r2r.getXRange() : r2r.getYRange();
        Double xmin = range.getMin();
        Double xmax = range.getMax();
        this.addTerminatingCaps(xmin, xmax);
    }

    public void addTerminatingCaps(Double xmin, Double xmax) {
        this.add(new RealRange(xmin, xmin));
        this.add(new RealRange(xmax, xmax));
        this.sortAndRemoveOverlapping();
    }

    public void removeLessThan(double rangeMin) {
        ArrayList<RealRange> copyList = new ArrayList<RealRange>(this.rangeList);
        for (int i = 0; i < copyList.size(); ++i) {
            RealRange range = (RealRange)copyList.get(i);
            if (!(range.getRange() < rangeMin)) continue;
            this.rangeList.remove(range);
        }
    }

    public boolean includes(RealRange rr) {
        for (RealRange range : this.rangeList) {
            if (!range.includes(rr)) continue;
            return true;
        }
        return false;
    }

    public void setDirection(RealRange.Direction direction) {
        this.direction = direction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Direction: " + (Object)((Object)this.direction) + "; size: " + this.rangeList.size() + "\n(");
        for (int i = 0; i < this.rangeList.size(); ++i) {
            sb.append("" + this.rangeList.get(i));
            if ((i + 1) % 5 != 0) continue;
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }

    public void format(int decimalPlaces) {
        for (RealRange range : this.rangeList) {
            range.format(decimalPlaces);
        }
    }

    public RealArray getGaps() {
        RealArray gaps = null;
        if (this.rangeList.size() > 1) {
            gaps = new RealArray();
            for (int i = 1; i < this.rangeList.size(); ++i) {
                double dist = this.rangeList.get(i).getMin() - this.rangeList.get(i - 1).getMax();
                gaps.addElement(dist);
            }
        }
        return gaps;
    }

    public void extendRangesBy(double tolerance) {
        if (this.rangeList.size() > 0) {
            this.rangeList.get(0).extendLowerEndBy(tolerance);
            for (int i = 1; i < this.rangeList.size(); ++i) {
                RealRange range0 = this.rangeList.get(i - 1);
                RealRange range1 = this.rangeList.get(i);
                double gap = range1.getMin() - range0.getMax();
                if (gap < tolerance * 2.0) {
                    range0.extendUpperEndBy(gap / 2.0);
                    range1.extendLowerEndBy(gap / 2.0);
                    continue;
                }
                range0.extendUpperEndBy(tolerance);
                range1.extendLowerEndBy(tolerance);
            }
            this.rangeList.get(this.rangeList.size() - 1).extendUpperEndBy(tolerance);
        }
    }
}

