/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.learn;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.clauses.ClauseStore;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.search.loop.learn.Learn;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;

public class LearnSignedClauses<E extends ExplanationForSignedClause>
implements Learn {
    private final Solver mSolver;
    private long nbsol = 0L;
    private E lastExplanation;
    private final ClauseStore ngstore;
    private final int max_card;

    public LearnSignedClauses(Solver solver) {
        this.mSolver = solver;
        solver.getModel().getClauseBuilder();
        this.ngstore = this.mSolver.getModel().getClauseConstraint().getClauseStore();
        this.max_card = this.mSolver.getModel().getSettings().getMaxLearntClauseCardinality();
    }

    public void setExplanation(E explanation) {
        this.lastExplanation = explanation;
    }

    public E getExplanation() {
        return this.lastExplanation;
    }

    @Override
    public boolean record(Solver solver) {
        if (this.nbsol == solver.getSolutionCount()) {
            this.onFailure();
        } else {
            ++this.nbsol;
            this.onSolution();
        }
        return true;
    }

    @Override
    public void forget(Solver solver) {
        this.addLearntConstraint();
        this.ngstore.forget();
        ((ExplanationForSignedClause)this.lastExplanation).recycle();
    }

    private void onFailure() {
        ContradictionException cex = this.mSolver.getContradictionException();
        assert (cex.v != null || cex.c != null) : this.getClass().getName() + ".onContradiction incoherent state";
        ((ExplanationForSignedClause)this.lastExplanation).learnSignedClause(cex);
        int upto = this.mSolver.getDecisionPath().size() - ((ExplanationForSignedClause)this.lastExplanation).getAssertingLevel();
        DecisionPath path = this.mSolver.getDecisionPath();
        Decision dec = null;
        for (int i = path.size() - 1; i > 1 && !(dec = (IntDecision)path.getDecision(i)).hasNext() && dec.getArity() > 1; --i) {
        }
        if (dec != null && dec.getPosition() - ((ExplanationForSignedClause)this.lastExplanation).getAssertingLevel() > 0) {
            this.mSolver.getMeasures().incBackjumpCount();
        }
        assert (upto >= 0 && upto <= this.mSolver.getDecisionPath().size());
        this.mSolver.setJumpTo(upto);
    }

    protected void onSolution() {
        if (this.mSolver.getObjectiveManager().isOptimization()) {
            try {
                this.mSolver.getObjectiveManager().postDynamicCut();
                throw new UnsupportedOperationException("LearnSignedClauses: posting cut does not fail as expected.");
            }
            catch (ContradictionException e) {
                this.onFailure();
            }
        } else {
            ((ExplanationForSignedClause)this.lastExplanation).learnSolution(this.mSolver.getDecisionPath());
            this.mSolver.setJumpTo(-1);
        }
    }

    private void addLearntConstraint() {
        if (this.lastExplanation != null && ((ExplanationForSignedClause)this.lastExplanation).getCardinality() > 0 && ((ExplanationForSignedClause)this.lastExplanation).getCardinality() <= this.max_card) {
            ((ExplanationForSignedClause)this.lastExplanation).extractConstraint(this.mSolver.getModel(), this.ngstore);
        }
    }
}

