/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats.spi;

import jdplus.toolkit.base.api.advanced.dstats.Distributions;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.random.MersenneTwister;

class DProcessor
implements Distributions.Processor.Distribution {
    private final ContinuousDistribution distribution;
    private final RandomNumberGenerator rng = MersenneTwister.fromSystemNanoTime();

    DProcessor(ContinuousDistribution distribution) {
        this.distribution = distribution;
    }

    public double random() {
        return this.distribution.random(this.rng);
    }

    public double probability(double x, ProbabilityType type) {
        return this.distribution.getProbability(x, type);
    }

    public double probabilityInverse(double p, ProbabilityType type) {
        return this.distribution.getProbabilityInverse(p, type);
    }

    public double density(double x) {
        return this.distribution.getDensity(x);
    }
}

