/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.composite;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import jdplus.toolkit.base.core.ssf.basic.MeasurementError;
import jdplus.toolkit.base.core.ssf.composite.CompositeDynamics;
import jdplus.toolkit.base.core.ssf.composite.CompositeInitialization;
import jdplus.toolkit.base.core.ssf.composite.CompositeLoading;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.ISsfMeasurement;
import jdplus.toolkit.base.core.ssf.univariate.Measurement;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;

public class CompositeSsf
extends Ssf {
    private final int[] pos;
    private final int[] dim;

    CompositeSsf(int[] cmpPos, int[] cmpDim, ISsfInitialization init, ISsfDynamics dynamics, ISsfMeasurement measurement) {
        super(init, dynamics, measurement);
        this.pos = cmpPos;
        this.dim = cmpDim;
    }

    public int[] componentsPosition() {
        return (int[])this.pos.clone();
    }

    public int[] componentsDimension() {
        return (int[])this.dim.clone();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<StateComponent> components = new ArrayList<StateComponent>();
        private final List<ISsfLoading> loadings = new ArrayList<ISsfLoading>();
        private ISsfError measurementError;
        private int[] dim;
        private int[] pos;

        public Builder add(StateComponent cmp, ISsfLoading loading) {
            this.components.add(cmp);
            this.loadings.add(loading);
            return this;
        }

        public Builder measurementError(ISsfError measurementError) {
            this.measurementError = measurementError;
            return this;
        }

        public Builder measurementError(double var) {
            this.measurementError = MeasurementError.of(var);
            return this;
        }

        public CompositeSsf build() {
            if (this.components.isEmpty()) {
                return null;
            }
            int n = this.components.size();
            this.dim = new int[n];
            this.pos = new int[n];
            ISsfInitialization[] i = new ISsfInitialization[n];
            ISsfDynamics[] d = new ISsfDynamics[n];
            ISsfLoading[] l = new ISsfLoading[n];
            int cpos = 0;
            for (int j = 0; j < n; ++j) {
                StateComponent cur = this.components.get(j);
                i[j] = cur.initialization();
                d[j] = cur.dynamics();
                l[j] = this.loadings.get(j);
                this.pos[j] = cpos;
                this.dim[j] = i[j].getStateDim();
                cpos += this.dim[j];
            }
            ISsfLoading cl = Loading.optimize(new CompositeLoading(this.dim, l), cpos);
            return new CompositeSsf(this.pos, this.dim, new CompositeInitialization(this.dim, i), new CompositeDynamics(this.dim, d), new Measurement(cl, this.measurementError));
        }

        public int[] getComponentsDimension() {
            return this.dim;
        }

        public int[] getComponentsPosition() {
            return this.pos;
        }
    }
}

