/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.utility;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixNorms;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.utility.Randoms;
import lombok.Generated;

public final class LoadingCoherence {
    public static void check(ISsfLoading l, int dim) {
        LoadingCoherence.check(l, dim, 0, 1);
    }

    public static void check(ISsfLoading l, int dim, int start, int end) {
        for (int j = start; j < end; ++j) {
            DataBlock z = DataBlock.make(dim);
            l.Z(j, z);
            FastMatrix M = Randoms.randomMatrix(dim);
            FastMatrix P = Randoms.randomSymmetricMatrix(dim);
            DataBlock v = Randoms.randomArray(dim);
            double zx = l.ZX(j, v);
            if (Math.abs(zx - z.dot(v)) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            DataBlock zm = DataBlock.make(M.getColumnsCount());
            zm.product(z, M.columnsIterator());
            DataBlock w = DataBlock.make(M.getColumnsCount());
            l.ZM(j, M, w);
            if (zm.distance((DoubleSeq)w) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            w = v.deepClone();
            l.XpZd(j, w, 3.3);
            DataBlock w2 = v.deepClone();
            w2.addAY(3.3, z);
            if (w2.distance((DoubleSeq)w) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            DataBlock zp = DataBlock.make(P.getColumnsCount());
            zp.product(z, P.columnsIterator());
            if (Math.abs(zp.dot(z) - l.ZVZ(j, P)) > 1.0E-9) {
                throw new SsfException("Invalid model definition");
            }
            FastMatrix p = P.deepClone();
            l.VpZdZ(j, p, 3.3);
            FastMatrix q = P.deepClone();
            GeneralMatrix.aXYt_p_A(3.3, z, z, q);
            if (!(MatrixNorms.frobeniusNorm(q.minus(p)) > 1.0E-9)) continue;
            throw new SsfException("Invalid model definition");
        }
    }

    @Generated
    private LoadingCoherence() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

