/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries.util;

import internal.toolkit.base.api.timeseries.util.ObsList;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntUnaryOperator;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import lombok.Generated;

interface ByObjObsList<T>
extends ObsList {
    public void clear();

    public void add(T var1, double var2);

    public static final class Sortable<T>
    implements ByObjObsList<T> {
        private final ToPeriodIdFunc<T> tsPeriodIdFunc;
        private final Comparator<T> comparator;
        private final List<Obs<T>> list;
        private boolean sorted;
        private T latestPeriod;

        Sortable(ToPeriodIdFunc<T> tsPeriodIdFunc, Comparator<T> comparator) {
            this.tsPeriodIdFunc = tsPeriodIdFunc;
            this.comparator = comparator;
            this.list = new ArrayList<Obs<T>>();
            this.sorted = true;
            this.latestPeriod = null;
        }

        boolean isSorted() {
            return this.sorted;
        }

        @Override
        public void clear() {
            this.list.clear();
            this.sorted = true;
            this.latestPeriod = null;
        }

        @Override
        public void add(T period, double value) {
            this.list.add(new Obs<T>(period, value));
            this.sorted = this.sorted && (this.latestPeriod == null || this.comparator.compare(this.latestPeriod, period) <= 0);
            this.latestPeriod = period;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public double getValue(int index) {
            return this.list.get((int)index).value;
        }

        @Override
        public IntUnaryOperator getPeriodIdFunc(TsUnit unit, LocalDateTime reference) {
            return o -> this.tsPeriodIdFunc.apply(unit, reference, this.list.get((int)o).period);
        }

        @Override
        public void sortByPeriod() {
            if (!this.sorted) {
                this.list.sort(Comparator.comparing(o -> o.period, this.comparator));
                this.sorted = true;
                this.latestPeriod = this.list.get((int)(this.list.size() - 1)).period;
            }
        }

        private static final class Obs<T> {
            final T period;
            final double value;

            @Generated
            public Obs(T period, double value) {
                this.period = period;
                this.value = value;
            }
        }
    }

    public static final class PreSorted<T>
    implements ByObjObsList<T> {
        private final ToPeriodIdFunc<T> tsPeriodIdFunc;
        private Object[] periods;
        private double[] values;
        private int size;

        PreSorted(ToPeriodIdFunc<T> tsPeriodIdFunc, int initialCapacity) {
            this.tsPeriodIdFunc = tsPeriodIdFunc;
            this.periods = new Object[initialCapacity];
            this.values = new double[initialCapacity];
            this.size = 0;
        }

        private void grow() {
            int oldCapacity = this.periods.length;
            int newCapacity = Math.min(oldCapacity * 2, Integer.MAX_VALUE);
            this.periods = Arrays.copyOf(this.periods, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public void add(T period, double value) {
            if (this.size + 1 == this.periods.length) {
                this.grow();
            }
            this.periods[this.size] = period;
            this.values[this.size] = value;
            ++this.size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void sortByPeriod() {
        }

        @Override
        public IntUnaryOperator getPeriodIdFunc(TsUnit unit, LocalDateTime reference) {
            return o -> this.tsPeriodIdFunc.apply(unit, reference, this.periods[o]);
        }

        @Override
        public double getValue(int index) throws IndexOutOfBoundsException {
            return this.values[index];
        }

        @Override
        public Doubles getValues() {
            return Doubles.ofInternal(Arrays.copyOf(this.values, this.size));
        }
    }

    public static interface ToPeriodIdFunc<T> {
        public int apply(TsUnit var1, LocalDateTime var2, T var3);
    }
}

