/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.logging.Logger;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.util.VKMUtil;

public class SingleValue
extends Value {
    private double value;
    private Attribute attribute;

    public static SingleValue createSimpleSingleValue(Attribute attribute, double val) {
        SingleValue value = new SingleValue(attribute, val, String.valueOf(attribute.getId()) + "-" + VKMUtil.getFormattedDoubleString(val));
        return value;
    }

    public static SingleValue createSimpleSingleValue(Attribute attribute, double val, String id) {
        SingleValue value = new SingleValue(attribute, val, id);
        return value;
    }

    protected SingleValue(String id) {
        super(id);
        this.setDescription(id);
    }

    public SingleValue(Attribute attribute, double value, String id) {
        super(id);
        if (attribute == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Illegal attribute argument - Attribute is null!");
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "DefaultSingleValue", ex);
            throw ex;
        }
        this.attribute = attribute;
        this.value = value;
        this.setDescription(id);
    }

    @Override
    public int computeCachedHashCode() {
        int hash = 17;
        hash = 37 * hash + this.attribute.hashCode();
        long tmp = Double.doubleToLongBits(this.value);
        hash = 37 * hash + (int)(tmp ^ tmp >>> 32);
        return hash;
    }

    public double doubleValue() {
        return this.value;
    }

    @Override
    public boolean isDefaultValue() {
        return this.value == 0.0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SingleValue other = (SingleValue)object;
        if (!this.attribute.equals(other.attribute)) {
            return false;
        }
        return Value.equalValues(this.value, other.value);
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public String getDescription() {
        if (this.attribute.isNumeric()) {
            return VKMUtil.getFormattedDoubleString(this.doubleValue());
        }
        return super.getDescription();
    }

    @Override
    public String getId() {
        if (this.attribute.isNumeric()) {
            return String.valueOf(this.value);
        }
        return super.getId();
    }

    @Override
    public boolean isMissingValue() {
        return false;
    }

    @Override
    public boolean isValueContainedInInstance(DataRecord instance) {
        return Value.equalValues(this.value, instance.getValue(this.attribute));
    }

    public void setValue(DataRecord instance) {
        if (!(this.attribute instanceof NominalAttribute)) {
            throw new UnsupportedOperationException("This is only supported for BasicAttributes!");
        }
        instance.setValue(this.attribute, this.value);
    }

    public String toString() {
        return this.getId();
    }
}

