/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.MarkovJumpsSubstitutionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelRobustCountingExecutor {
    private final ExecutorService pool;
    private final List<DerivativeCaller> derivativeCaller = new ArrayList<DerivativeCaller>();
    public static final boolean DEBUG_PARALLEL_EVALUATION = false;

    public ParallelRobustCountingExecutor(int n, MarkovJumpsSubstitutionModel markovJumpsSubstitutionModel, int n2) {
        int n3 = Math.min(n, n2);
        this.pool = Executors.newFixedThreadPool(n3);
        int n4 = (n2 + n3 - 1) / n3;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            this.derivativeCaller.add(new DerivativeCaller(n5, Math.min(n5 + n4, n2), markovJumpsSubstitutionModel));
            n5 += n3;
        }
    }

    public void execute(double[] dArray) {
        for (DerivativeCaller derivativeCaller : this.derivativeCaller) {
            derivativeCaller.setOutput(dArray);
        }
        try {
            this.pool.invokeAll(this.derivativeCaller);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static class DerivativeCaller
    implements Callable<Void> {
        private final int start;
        private final int end;
        private double[] out;

        public DerivativeCaller(int n, int n2, MarkovJumpsSubstitutionModel markovJumpsSubstitutionModel) {
            this.start = n;
            this.end = n2;
        }

        public void setOutput(double[] dArray) {
            this.out = dArray;
        }

        @Override
        public Void call() throws Exception {
            for (int i = this.start; i < this.end; ++i) {
                this.out[i] = 0.0;
            }
            return null;
        }
    }
}

