/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MultivariateFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class GeneralizedAdditiveModel
extends AbstractModelLikelihood
implements MultivariateFunction {
    protected Parameter dependentParam;
    protected List<Parameter> independentParam;
    protected List<DesignMatrix> designMatrix;
    protected int[] scaleDesign;
    protected Parameter scaleParameter;
    protected int numIndependentVariables = 0;
    protected int numRandomEffects = 0;
    protected int N;
    protected List<Parameter> randomEffects = null;

    public GeneralizedAdditiveModel(Parameter parameter) {
        super("gamGpModel");
        this.dependentParam = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
            this.N = parameter.getDimension();
        } else {
            this.N = 0;
        }
    }

    public void addIndependentParameter(Parameter parameter, DesignMatrix designMatrix, Parameter parameter2) {
        if (this.designMatrix == null) {
            this.designMatrix = new ArrayList<DesignMatrix>();
        }
        if (this.independentParam == null) {
            this.independentParam = new ArrayList<Parameter>();
        }
        if (this.N == 0) {
            this.N = designMatrix.getRowDimension();
        }
        this.designMatrix.add(designMatrix);
        this.independentParam.add(parameter);
        if (this.designMatrix.size() != this.independentParam.size()) {
            throw new RuntimeException("Independent variables and their design matrices are out of sync");
        }
        this.addVariable(parameter);
        this.addVariable(designMatrix);
        ++this.numIndependentVariables;
        Logger.getLogger("dr.inference").info("\tAdding independent predictors '" + parameter.getStatisticName() + "' with design matrix '" + designMatrix.getStatisticName() + "'");
    }

    protected double calculateLogLikelihood(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    protected double calculateLogLikelihood() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        return this.calculateLogLikelihood();
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public double evaluate(double[] dArray) {
        return this.calculateLogLikelihood(dArray);
    }

    @Override
    public int getNumArguments() {
        int n = 0;
        for (Parameter parameter : this.independentParam) {
            n += parameter.getDimension();
        }
        return n;
    }

    @Override
    public double getLowerBound(int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 > this.independentParam.get(n3).getDimension()) {
            n2 -= this.independentParam.get(n3).getDimension();
            ++n3;
        }
        return this.independentParam.get(n3).getBounds().getLowerLimit(n2);
    }

    @Override
    public double getUpperBound(int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 > this.independentParam.get(n3).getDimension()) {
            n2 -= this.independentParam.get(n3).getDimension();
            ++n3;
        }
        return this.independentParam.get(n3).getBounds().getUpperLimit(n2);
    }
}

