/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;

public class TruncatedDistribution
extends AbstractContinuousDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return TruncatedDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return TruncatedDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return TruncatedDistribution.this.upper;
        }
    };
    private final Distribution source;
    private final double lower;
    private final double upper;
    private final double normalization;
    private final double lowerCDF;

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public TruncatedDistribution(Distribution distribution, double d, double d2) {
        this.source = distribution;
        if (d == d2) {
            throw new IllegalArgumentException("upper equals lower");
        }
        if (distribution.getProbabilityDensityFunction().getLowerBound() > d) {
            d = distribution.getProbabilityDensityFunction().getLowerBound();
        }
        if (distribution.getProbabilityDensityFunction().getUpperBound() < d2) {
            d2 = distribution.getProbabilityDensityFunction().getUpperBound();
        }
        this.lower = d;
        this.upper = d2;
        this.lowerCDF = !Double.isInfinite(this.lower) ? distribution.cdf(d) : 0.0;
        double d3 = 1.0;
        if (!Double.isInfinite(this.upper)) {
            d3 = distribution.cdf(d2);
        }
        this.normalization = d3 - this.lowerCDF;
    }

    @Override
    public double pdf(double d) {
        if (d >= this.upper && d < this.lower) {
            return 0.0;
        }
        return this.source.pdf(d) / this.normalization;
    }

    @Override
    public double logPdf(double d) {
        return Math.log(this.pdf(d));
    }

    @Override
    public double cdf(double d) {
        double d2 = d < this.lower ? 0.0 : (d >= this.lower && d < this.upper ? (this.source.cdf(d) - this.lowerCDF) / this.normalization : 1.0);
        return d2;
    }

    @Override
    public double quantile(double d) {
        if (d == 0.0) {
            return this.lower;
        }
        if (d == 1.0) {
            return this.upper;
        }
        if (Double.isInfinite(this.lower) && Double.isInfinite(this.upper)) {
            return this.source.quantile(d);
        }
        try {
            return super.inverseCumulativeProbability(d);
        }
        catch (MathException mathException) {
            return Double.NaN;
        }
    }

    @Override
    public double mean() {
        if (this.source != null) {
            return this.source.mean();
        }
        throw new IllegalArgumentException("Distribution is null");
    }

    @Override
    public double variance() {
        if (this.source != null) {
            return this.source.variance();
        }
        throw new IllegalArgumentException("Distribution is null");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    protected double getInitialDomain(double d) {
        if (!Double.isInfinite(this.lower) && !Double.isInfinite(this.upper)) {
            return (this.upper + this.lower) / 2.0;
        }
        if (!Double.isInfinite(this.upper)) {
            return this.upper / 2.0;
        }
        if (!Double.isInfinite(this.lower)) {
            return this.lower * 2.0;
        }
        return d;
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return this.lower;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        return this.upper;
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        return this.cdf(d);
    }
}

