/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aemanipulator;

import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import java.util.Iterator;

public class CNFIterator
implements Iterator<AEBooleanExpr> {
    AEBooleanExpr m_curNode;
    AEBooleanExpr m_root;
    AEBooleanExpr m_prev;

    public CNFIterator(AEBooleanExpr aEBooleanExpr) {
        assert (aEBooleanExpr != null);
        this.m_root = aEBooleanExpr;
        this.m_curNode = this.leftMost(aEBooleanExpr);
        this.m_prev = null;
    }

    @Override
    public boolean hasNext() {
        return this.m_curNode != null;
    }

    @Override
    public AEBooleanExpr next() {
        this.m_prev = this.m_curNode;
        this.findNext();
        return this.m_prev;
    }

    @Override
    public void remove() {
        AEBooleanExpr aEBooleanExpr;
        if (this.m_prev == this.m_root) {
            this.m_prev = null;
            this.m_root = null;
            return;
        }
        if (this.m_prev == null) {
            throw new IllegalStateException("Iterator call sequence error.");
        }
        AEAnd aEAnd = (AEAnd)this.m_prev.getParent();
        IAENode iAENode = aEAnd.getParent();
        if (iAENode == this.m_root.getParent()) {
            assert (aEAnd == this.m_root);
            this.m_root = this.isLeftChild(aEAnd, this.m_prev) ? aEAnd.getRightOperand() : aEAnd.getLeftOperand();
            return;
        }
        AEAnd aEAnd2 = (AEAnd)iAENode;
        AEBooleanExpr aEBooleanExpr2 = aEBooleanExpr = this.isLeftChild(aEAnd, this.m_prev) ? aEAnd.getRightOperand() : aEAnd.getLeftOperand();
        if (this.isLeftChild(aEAnd2, aEAnd)) {
            aEAnd2.setLeftOperand(aEBooleanExpr);
        } else {
            aEAnd2.setRightOperand(aEBooleanExpr);
        }
        this.m_prev = null;
    }

    public AEBooleanExpr getExpr() {
        return this.m_root;
    }

    private AEBooleanExpr leftMost(AEBooleanExpr aEBooleanExpr) {
        while (aEBooleanExpr instanceof AEAnd) {
            aEBooleanExpr = ((AEAnd)aEBooleanExpr).getLeftOperand();
        }
        return aEBooleanExpr;
    }

    private void findNext() {
        IAENode iAENode = this.m_curNode.getParent();
        AEBooleanExpr aEBooleanExpr = this.m_curNode;
        this.m_curNode = null;
        while (this.m_root.getParent() != iAENode) {
            assert (iAENode instanceof AEAnd);
            AEAnd aEAnd = (AEAnd)iAENode;
            if (this.isLeftChild(aEAnd, aEBooleanExpr)) {
                this.m_curNode = this.leftMost(aEAnd.getRightOperand());
                return;
            }
            aEBooleanExpr = aEAnd;
            iAENode = aEAnd.getParent();
        }
    }

    private boolean isLeftChild(AEAnd aEAnd, AEBooleanExpr aEBooleanExpr) {
        return aEAnd.getLeftOperand() == aEBooleanExpr;
    }
}

