/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CachedPainter {
    private static final Map cacheMap = new HashMap();
    private int maxCachedImageSize = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache getCache(Object key) {
        Map map = cacheMap;
        synchronized (map) {
            Cache cache = (Cache)cacheMap.get(key);
            if (cache == null) {
                cache = new Cache(1);
                cacheMap.put(key, cache);
            }
            return cache;
        }
    }

    public CachedPainter(int cacheCount) {
        CachedPainter.getCache(this.getClass()).setMaxCount(cacheCount);
    }

    protected void paint(Component c, Graphics g, int x, int y, int w, int h, Object args) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Class<?> key = this.getClass();
        if (CachedPainter.getCache(key).getMaxCount() == 0 || w * h > this.maxCachedImageSize) {
            g.translate(x, y);
            this.paintToImage(c, g, w, h, args);
            g.translate(-x, -y);
            return;
        }
        GraphicsConfiguration config = c.getGraphicsConfiguration();
        Cache cache = CachedPainter.getCache(key);
        Image image = cache.getImage(key, config, w, h, args);
        int attempts = 0;
        do {
            boolean draw = false;
            if (image instanceof VolatileImage) {
                switch (((VolatileImage)image).validate(config)) {
                    case 2: {
                        ((VolatileImage)image).flush();
                        image = null;
                        break;
                    }
                    case 1: {
                        draw = true;
                    }
                }
            }
            if (image == null) {
                image = this.createImage(c, w, h, config);
                cache.setImage(key, config, w, h, args, image);
                draw = true;
            }
            if (draw) {
                this.paintToImage(c, image, w, h, args);
            }
            this.paintImage(c, g, x, y, w, h, image, args);
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost() && ++attempts < 3);
    }

    protected void paintToImage(Component c, Image image, int w, int h, Object args) {
        Graphics g2 = image.getGraphics();
        this.paintToImage(c, g2, w, h, args);
        g2.dispose();
    }

    protected abstract void paintToImage(Component var1, Graphics var2, int var3, int var4, Object var5);

    protected void paintImage(Component c, Graphics g, int x, int y, int w, int h, Image image, Object args) {
        g.drawImage(image, x, y, null);
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        if (config == null) {
            return new BufferedImage(w, h, 1);
        }
        return config.createCompatibleVolatileImage(w, h);
    }

    public int getMaxCachedImageSize() {
        return this.maxCachedImageSize;
    }

    public void setMaxCachedImageSize(int maxCachedImageSize) {
        this.maxCachedImageSize = maxCachedImageSize;
    }

    private static class Cache {
        private int maxCount;
        private List entries;

        Cache(int maxCount) {
            this.maxCount = maxCount;
            this.entries = new ArrayList(maxCount);
        }

        synchronized void setMaxCount(int maxCount) {
            this.maxCount = maxCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Entry getEntry(Object key, GraphicsConfiguration config, int w, int h, Object args) {
            Cache cache = this;
            synchronized (cache) {
                Entry entry;
                for (int counter = this.entries.size() - 1; counter >= 0; --counter) {
                    entry = (Entry)((SoftReference)this.entries.get(counter)).get();
                    if (entry == null) {
                        this.entries.remove(counter);
                        continue;
                    }
                    if (!entry.equals(config, w, h, args)) continue;
                    return entry;
                }
                entry = new Entry(config, w, h, args);
                if (this.entries.size() == this.maxCount) {
                    this.entries.remove(0);
                }
                this.entries.add(new SoftReference<Entry>(entry));
                return entry;
            }
        }

        public Image getImage(Object key, GraphicsConfiguration config, int w, int h, Object args) {
            Entry entry = this.getEntry(key, config, w, h, args);
            return entry.getImage();
        }

        public void setImage(Object key, GraphicsConfiguration config, int w, int h, Object args, Image image) {
            Entry entry = this.getEntry(key, config, w, h, args);
            entry.setImage(image);
        }

        private static class Entry {
            private GraphicsConfiguration config;
            private Object args;
            private Image image;
            private int w;
            private int h;

            Entry(GraphicsConfiguration config, int w, int h, Object args) {
                this.config = config;
                this.args = args;
                this.w = w;
                this.h = h;
            }

            public void setImage(Image image) {
                this.image = image;
            }

            public Image getImage() {
                return this.image;
            }

            public String toString() {
                StringBuilder value = new StringBuilder(super.toString() + "[ graphicsConfig=" + this.config + ", image=" + this.image + ", w=" + this.w + ", h=" + this.h);
                if (this.args != null) {
                    value.append(", ");
                    value.append(this.args);
                }
                value.append("]");
                return value.toString();
            }

            public boolean equals(GraphicsConfiguration config, int w, int h, Object args) {
                if (this.w == w && this.h == h && (this.config != null && this.config.equals(config) || this.config == null && config == null)) {
                    if (this.args == null && args == null) {
                        return true;
                    }
                    if (this.args != null && args != null) {
                        return this.args.equals(args);
                    }
                }
                return false;
            }
        }
    }
}

