## ----setup, include=FALSE-----------------------------------------------------
    knitr::opts_chunk$set(echo = TRUE, message = FALSE, warning = FALSE)

# Required packages
required_packages <- c(
  "deSolve", "sp", "tm", "glmnet", "caret",
  "kernlab", "survival", "randomForest", "EpidigiR"
)

missing_pkgs <- required_packages[!vapply(required_packages, requireNamespace, logical(1L), quietly = TRUE)]
if (length(missing_pkgs) > 0) {
  message("Missing packages: ", paste(missing_pkgs, collapse = ", "))
  message("Install them manually before running this vignette: install.packages(missing_pkgs)")
}

for (pkg in required_packages) {
  if (requireNamespace(pkg, quietly = TRUE)) {
    suppressPackageStartupMessages(library(pkg, character.only = TRUE))
  }
}
# Prepare datasets
if (exists("ml_data")) {
  ml_data$outcome <- as.factor(ml_data$outcome)
}
if (exists("clinical_data")) {
  clinical_data$outcome <- as.factor(clinical_data$outcome)
}

## -----------------------------------------------------------------------------
data(epi_prevalence)
result <- epi_analyze(
  epi_prevalence,
  outcome = "cases",
  population = "population",
  group = "region",
  type = "summary"
)
print(result)

## -----------------------------------------------------------------------------
sir_result <- epi_analyze(
  data = NULL, outcome = NULL, type = "sir",
  N = 1000, beta = 0.3, gamma = 0.1, days = 50
)
epi_visualize(sir_result, x = "time", y = "Infected", type = "curve", main = "Epidemic Curve")

## -----------------------------------------------------------------------------
data(epi_prevalence)
coordinates(epi_prevalence) <- ~lon + lat
epi_visualize(epi_prevalence, x = "prevalence", type = "map", main = "Prevalence Map")

## -----------------------------------------------------------------------------
data(clinical_data)
clinical_data$outcome <- as.factor(clinical_data$outcome)
model <- epi_model(clinical_data, formula = outcome ~ age + health_score + dose, type = "logistic")
head(model$predictions)

## -----------------------------------------------------------------------------
rf_model <- epi_model(clinical_data, formula = outcome ~ age + health_score + dose, type = "rf")
head(rf_model$predictions)

## -----------------------------------------------------------------------------
data(daly_data)
epi_analyze(daly_data, outcome = NULL, type = "daly")

## -----------------------------------------------------------------------------
data(geno_data)
epi_model(geno_data, formula = outcome ~ snp1 + snp2, type = "snp")

## -----------------------------------------------------------------------------
data(survey_data)
epi_analyze(survey_data, outcome = NULL, type = "age_standardize")

## -----------------------------------------------------------------------------
data(ml_data)
epi_model(ml_data, formula = outcome ~ age + exposure + genetic_risk, type = "logistic")

## -----------------------------------------------------------------------------
data(survival_data)
epi_model(survival_data, type = "survival")

## -----------------------------------------------------------------------------
data(nlp_data)
nlp_result <- epi_analyze(nlp_data, outcome = NULL, population = NULL, type = "nlp", n = 5)
head(nlp_result)

## -----------------------------------------------------------------------------
data(ml_data)
epi_model(ml_data[, c("age", "exposure", "genetic_risk")], type = "kmeans", k = 3)

## -----------------------------------------------------------------------------
data(ml_data)
ml_data$outcome <- as.factor(ml_data$outcome)
svm_model <- epi_model(ml_data, formula = outcome ~ age + exposure + genetic_risk, type = "svmRadial")
svm_model$performance

## -----------------------------------------------------------------------------
data(diagnostic_data)
epi_analyze(diagnostic_data, outcome = NULL, type = "diagnostic")

## -----------------------------------------------------------------------------
data(clinical_data)
epi_visualize(clinical_data, x = "arm", y = "outcome", type = "boxplot", main = "Outcome by Treatment Arm")

## -----------------------------------------------------------------------------
data(ml_data)
epi_visualize(ml_data, x = "age", y = "outcome", type = "scatter", main = "Age vs. Disease Outcome")

