/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.likelihood;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.HessianWrtParameterProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Parameter;
import org.apache.commons.math.util.FastMath;
import org.ohdsi.data.ColumnMajorSortedCoxData;
import org.ohdsi.data.CoxData;
import org.ohdsi.data.SortedCoxData;
import org.ohdsi.likelihood.ConditionalPoissonLikelihood;
import org.ohdsi.likelihood.CoxPartialLikelihood;

public class MultivariableCoxPartialLikelihood
extends ConditionalPoissonLikelihood
implements GradientWrtParameterProvider,
HessianWrtParameterProvider {
    public MultivariableCoxPartialLikelihood(Parameter beta, SortedCoxData data) {
        super("multivariableCoxPartialLikelihood", beta, null, data);
    }

    @Override
    protected double calculateLogLikelihood() {
        int[] y = this.data.y;
        double[] x = this.data.x;
        int[] n = this.data.n;
        int[] strata = this.data.strata;
        double[] beta = this.beta.getParameterValues();
        double logLikelihood = 0.0;
        int resetIndex = 0;
        double denominator = 0.0;
        int i = 0;
        while (i < this.N) {
            if (i == strata[resetIndex]) {
                denominator = 0.0;
                ++resetIndex;
            }
            double rowXBeta = 0.0;
            int j = 0;
            while (j < this.J) {
                rowXBeta += x[i * this.J + j] * beta[j];
                ++j;
            }
            logLikelihood += (double)y[i] * rowXBeta - (double)n[i] * FastMath.log((double)(denominator += FastMath.exp((double)rowXBeta)));
            ++i;
        }
        return logLikelihood;
    }

    public static SortedCoxData exampleMultivariableData() {
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[6] = 1;
        int[] y = nArray;
        double[] x = new double[]{0.0, 2.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0};
        int[] nArray2 = new int[7];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[6] = 1;
        int[] yTimesTieCount = nArray2;
        int[] strata = new int[]{7};
        return new ColumnMajorSortedCoxData(y, x, strata, yTimesTieCount, null);
    }

    public static SortedCoxData exampleBladder() {
        int[] nArray = new int[340];
        nArray[16] = 1;
        nArray[28] = 1;
        nArray[32] = 1;
        nArray[33] = 1;
        nArray[40] = 1;
        nArray[41] = 1;
        nArray[44] = 1;
        nArray[45] = 1;
        nArray[46] = 1;
        nArray[48] = 1;
        nArray[49] = 1;
        nArray[50] = 1;
        nArray[52] = 1;
        nArray[53] = 1;
        nArray[54] = 1;
        nArray[55] = 1;
        nArray[56] = 1;
        nArray[57] = 1;
        nArray[58] = 1;
        nArray[64] = 1;
        nArray[68] = 1;
        nArray[69] = 1;
        nArray[72] = 1;
        nArray[88] = 1;
        nArray[89] = 1;
        nArray[92] = 1;
        nArray[93] = 1;
        nArray[94] = 1;
        nArray[96] = 1;
        nArray[97] = 1;
        nArray[98] = 1;
        nArray[99] = 1;
        nArray[100] = 1;
        nArray[101] = 1;
        nArray[102] = 1;
        nArray[116] = 1;
        nArray[124] = 1;
        nArray[125] = 1;
        nArray[126] = 1;
        nArray[127] = 1;
        nArray[128] = 1;
        nArray[129] = 1;
        nArray[130] = 1;
        nArray[131] = 1;
        nArray[136] = 1;
        nArray[140] = 1;
        nArray[144] = 1;
        nArray[145] = 1;
        nArray[146] = 1;
        nArray[148] = 1;
        nArray[149] = 1;
        nArray[150] = 1;
        nArray[151] = 1;
        nArray[152] = 1;
        nArray[160] = 1;
        nArray[164] = 1;
        nArray[168] = 1;
        nArray[169] = 1;
        nArray[170] = 1;
        nArray[171] = 1;
        nArray[176] = 1;
        nArray[177] = 1;
        nArray[178] = 1;
        nArray[179] = 1;
        nArray[180] = 1;
        nArray[181] = 1;
        nArray[182] = 1;
        nArray[183] = 1;
        nArray[184] = 1;
        nArray[185] = 1;
        nArray[186] = 1;
        nArray[187] = 1;
        nArray[196] = 1;
        nArray[212] = 1;
        nArray[216] = 1;
        nArray[217] = 1;
        nArray[218] = 1;
        nArray[219] = 1;
        nArray[224] = 1;
        nArray[228] = 1;
        nArray[232] = 1;
        nArray[233] = 1;
        nArray[252] = 1;
        nArray[253] = 1;
        nArray[254] = 1;
        nArray[256] = 1;
        nArray[260] = 1;
        nArray[264] = 1;
        nArray[265] = 1;
        nArray[272] = 1;
        nArray[273] = 1;
        nArray[274] = 1;
        nArray[275] = 1;
        nArray[276] = 1;
        nArray[277] = 1;
        nArray[278] = 1;
        nArray[279] = 1;
        nArray[280] = 1;
        nArray[281] = 1;
        nArray[282] = 1;
        nArray[283] = 1;
        nArray[292] = 1;
        nArray[293] = 1;
        nArray[300] = 1;
        nArray[301] = 1;
        nArray[302] = 1;
        nArray[303] = 1;
        nArray[308] = 1;
        nArray[324] = 1;
        nArray[325] = 1;
        nArray[326] = 1;
        nArray[332] = 1;
        int[] y = nArray;
        double[] time = new double[]{1.0, 1.0, 1.0, 1.0, 4.0, 4.0, 4.0, 4.0, 7.0, 7.0, 7.0, 7.0, 10.0, 10.0, 10.0, 10.0, 6.0, 10.0, 10.0, 10.0, 14.0, 14.0, 14.0, 14.0, 18.0, 18.0, 18.0, 18.0, 5.0, 18.0, 18.0, 18.0, 12.0, 16.0, 18.0, 18.0, 23.0, 23.0, 23.0, 23.0, 10.0, 15.0, 23.0, 23.0, 3.0, 16.0, 23.0, 23.0, 3.0, 9.0, 21.0, 23.0, 7.0, 10.0, 16.0, 24.0, 3.0, 15.0, 25.0, 25.0, 26.0, 26.0, 26.0, 26.0, 1.0, 26.0, 26.0, 26.0, 2.0, 26.0, 26.0, 26.0, 25.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 28.0, 30.0, 30.0, 30.0, 2.0, 17.0, 22.0, 30.0, 3.0, 6.0, 8.0, 12.0, 12.0, 15.0, 24.0, 31.0, 32.0, 32.0, 32.0, 32.0, 34.0, 34.0, 34.0, 34.0, 36.0, 36.0, 36.0, 36.0, 29.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 9.0, 17.0, 22.0, 24.0, 16.0, 19.0, 23.0, 29.0, 41.0, 41.0, 41.0, 41.0, 3.0, 43.0, 43.0, 43.0, 6.0, 43.0, 43.0, 43.0, 3.0, 6.0, 9.0, 44.0, 9.0, 11.0, 20.0, 26.0, 18.0, 48.0, 48.0, 48.0, 49.0, 49.0, 49.0, 49.0, 35.0, 51.0, 51.0, 51.0, 17.0, 53.0, 53.0, 53.0, 3.0, 15.0, 46.0, 51.0, 59.0, 59.0, 59.0, 59.0, 2.0, 15.0, 24.0, 30.0, 5.0, 14.0, 19.0, 27.0, 2.0, 8.0, 12.0, 13.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 5.0, 5.0, 5.0, 5.0, 9.0, 9.0, 9.0, 9.0, 10.0, 10.0, 10.0, 10.0, 13.0, 13.0, 13.0, 13.0, 3.0, 14.0, 14.0, 14.0, 1.0, 3.0, 5.0, 7.0, 18.0, 18.0, 18.0, 18.0, 17.0, 18.0, 18.0, 18.0, 2.0, 19.0, 19.0, 19.0, 17.0, 19.0, 21.0, 21.0, 22.0, 22.0, 22.0, 22.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 6.0, 12.0, 13.0, 26.0, 6.0, 27.0, 27.0, 27.0, 2.0, 29.0, 29.0, 29.0, 26.0, 35.0, 36.0, 36.0, 38.0, 38.0, 38.0, 38.0, 22.0, 23.0, 27.0, 32.0, 4.0, 16.0, 23.0, 27.0, 24.0, 26.0, 29.0, 40.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 1.0, 27.0, 43.0, 43.0, 44.0, 44.0, 44.0, 44.0, 2.0, 20.0, 23.0, 27.0, 45.0, 45.0, 45.0, 45.0, 2.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 46.0, 49.0, 49.0, 49.0, 49.0, 50.0, 50.0, 50.0, 50.0, 4.0, 24.0, 47.0, 50.0, 54.0, 54.0, 54.0, 54.0, 38.0, 54.0, 54.0, 54.0, 59.0, 59.0, 59.0, 59.0};
        double[] x = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 4.0, 4.0, 4.0, 4.0, 2.0, 2.0, 2.0, 2.0, 4.0, 4.0, 4.0, 4.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 6.0, 6.0, 6.0, 6.0, 5.0, 5.0, 5.0, 5.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 6.0, 6.0, 6.0, 6.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 7.0, 7.0, 7.0, 7.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 6.0, 6.0, 6.0, 6.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 5.0, 5.0, 5.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 3.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 4.0, 4.0, 4.0, 4.0, 1.0, 1.0, 1.0, 1.0, 3.0, 3.0, 3.0, 3.0};
        return new CoxData(y, time, x).getSortedData();
    }

    public static void main(String[] args) {
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[6] = 1;
        int[] y = nArray;
        double[] x = new double[]{0.0, 2.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        int[] nArray2 = new int[7];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[6] = 1;
        int[] yTimesTieCount = nArray2;
        int[] strata = new int[]{7};
        double beta = 0.3883064;
        SortedCoxData data = new SortedCoxData(y, x, strata, yTimesTieCount, null);
        Parameter.Default parameter = new Parameter.Default(beta);
        AbstractModelLikelihood cox = new MultivariableCoxPartialLikelihood((Parameter)parameter, data);
        System.err.println("M " + cox.getLogLikelihood());
        data = new SortedCoxData(y, x, strata, yTimesTieCount, null);
        parameter = new Parameter.Default(beta);
        cox = new CoxPartialLikelihood((Parameter)parameter, data);
        System.err.println("C " + cox.getLogLikelihood());
        System.err.println();
        int[] nArray3 = new int[7];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[3] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        y = nArray3;
        int[] nArray4 = new int[7];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[3] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        yTimesTieCount = nArray4;
        x = new double[]{0.0, 2.0, 1.0, 1.0, 0.0, 0.0, 1.0};
        strata = new int[]{4, 7};
        beta = 1.205852;
        data = new SortedCoxData(y, x, strata, yTimesTieCount, null);
        parameter = new Parameter.Default(beta);
        cox = new MultivariableCoxPartialLikelihood((Parameter)parameter, data);
        System.err.println("M " + cox.getLogLikelihood());
        data = new SortedCoxData(y, x, strata, yTimesTieCount, null);
        parameter = new Parameter.Default(beta);
        cox = new CoxPartialLikelihood((Parameter)parameter, data);
        System.err.println("C " + cox.getLogLikelihood());
        System.err.println();
        data = MultivariableCoxPartialLikelihood.exampleMultivariableData();
        double[] betas = new double[]{0.823619, 1.518213};
        parameter = new Parameter.Default(betas);
        cox = new MultivariableCoxPartialLikelihood((Parameter)parameter, data);
        System.err.println("M " + cox.getLogLikelihood());
        System.err.println(HessianWrtParameterProvider.getReportAndCheckForError((HessianWrtParameterProvider)((HessianWrtParameterProvider)cox), null));
        cox = new MultivariableCoxPartialLikelihood((Parameter)new Parameter.Default(new double[]{-0.4608773, -0.1012988}), MultivariableCoxPartialLikelihood.exampleBladder());
        System.err.println("M " + cox.getLogLikelihood());
        System.err.println(GradientWrtParameterProvider.getReportAndCheckForError((GradientWrtParameterProvider)((GradientWrtParameterProvider)cox), (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, null));
    }

    public int getDimension() {
        return this.beta.getDimension();
    }

    public double[] getGradientLogDensity() {
        int[] y = this.data.y;
        double[] x = this.data.x;
        int[] n = this.data.n;
        int[] strata = this.data.strata;
        double[] gradient = new double[this.beta.getDimension()];
        double[] xExpXBetaSum = new double[this.beta.getDimension()];
        double[] beta = this.beta.getParameterValues();
        double logLikelihood = 0.0;
        int resetIndex = 0;
        double denominator = 0.0;
        int i = 0;
        while (i < this.N) {
            if (i == strata[resetIndex]) {
                denominator = 0.0;
                ++resetIndex;
            }
            double rowXBeta = 0.0;
            int j = 0;
            while (j < this.J) {
                rowXBeta += x[i * this.J + j] * beta[j];
                int n2 = j;
                gradient[n2] = gradient[n2] + (double)y[i] * x[i * this.J + j];
                ++j;
            }
            double expXBeta = FastMath.exp((double)rowXBeta);
            denominator += expXBeta;
            int j2 = 0;
            while (j2 < this.J) {
                int n3 = j2;
                xExpXBetaSum[n3] = xExpXBetaSum[n3] + expXBeta * x[i * this.J + j2];
                ++j2;
            }
            j2 = 0;
            while (j2 < this.J) {
                int n4 = j2;
                gradient[n4] = gradient[n4] - (double)n[i] / denominator * xExpXBetaSum[j2];
                ++j2;
            }
            ++i;
        }
        return gradient;
    }

    public double[] getDiagonalHessianLogDensity() {
        int[] y = this.data.y;
        double[] x = this.data.x;
        int[] n = this.data.n;
        int[] strata = this.data.strata;
        double[] diagonalHessian = new double[this.beta.getDimension()];
        double[] xExpXBetaSum = new double[this.beta.getDimension()];
        double[] xSquaredExpXBetaSum = new double[this.beta.getDimension()];
        double[] beta = this.beta.getParameterValues();
        int resetIndex = 0;
        double denominator = 0.0;
        int i = 0;
        while (i < this.N) {
            if (i == strata[resetIndex]) {
                denominator = 0.0;
                ++resetIndex;
            }
            double rowXBeta = 0.0;
            int j = 0;
            while (j < this.J) {
                rowXBeta += x[i * this.J + j] * beta[j];
                ++j;
            }
            double expXBeta = FastMath.exp((double)rowXBeta);
            denominator += expXBeta;
            int j2 = 0;
            while (j2 < this.J) {
                double xExpXBeta = expXBeta * x[i * this.J + j2];
                int n2 = j2;
                xExpXBetaSum[n2] = xExpXBetaSum[n2] + xExpXBeta;
                int n3 = j2;
                xSquaredExpXBetaSum[n3] = xSquaredExpXBetaSum[n3] + xExpXBeta * x[i * this.J + j2];
                ++j2;
            }
            j2 = 0;
            while (j2 < this.J) {
                int n4 = j2;
                diagonalHessian[n4] = diagonalHessian[n4] - (double)n[i] / denominator * (xSquaredExpXBetaSum[j2] - xExpXBetaSum[j2] * xExpXBetaSum[j2] / denominator);
                ++j2;
            }
            ++i;
        }
        return diagonalHessian;
    }

    public double[][] getHessianLogDensity() {
        throw new RuntimeException("Not implemented yet");
    }
}

