/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NormalKindermannRamageGen
extends NormalGen {
    private double mu;
    private double sigma;

    public NormalKindermannRamageGen(RandomStream randomStream, NormalDist normalDist) {
        super(randomStream, normalDist);
        this.mu = normalDist.getMu();
        this.sigma = normalDist.getSigma();
    }

    public double nextDouble() {
        return NormalKindermannRamageGen.kindermanRamage(this.stream, this.mu, this.sigma);
    }

    public static double nextDouble(RandomStream randomStream, double d, double d2) {
        return NormalKindermannRamageGen.kindermanRamage(randomStream, d, d2);
    }

    private static double kindermanRamage(RandomStream randomStream, double d, double d2) {
        double d3;
        double d4 = randomStream.nextDouble();
        if (d4 < 0.884070402298758) {
            double d5 = randomStream.nextDouble();
            d3 = 2.216035867166471 * (1.13113163544418 * d4 + d5 - 1.0);
        } else if (d4 >= 0.973310954173898) {
            double d6;
            double d7;
            double d8;
            while ((d8 = randomStream.nextDouble()) * d8 * (d7 = (d6 = randomStream.nextDouble()) == 0.0 ? 0.0 : 2.455407482284126 - Math.log(d6)) > 2.455407482284126) {
            }
            d3 = d4 < 0.986655477086949 ? Math.pow(2.0 * d7, 0.5) : -Math.pow(2.0 * d7, 0.5);
        } else if (d4 >= 0.958720824790463) {
            double d9;
            double d10;
            double d11;
            double d12;
            do {
                d12 = randomStream.nextDouble();
                d11 = randomStream.nextDouble();
                d10 = d12 - d11;
                d9 = 2.216035867166471 - 0.63083480192196 * Math.min(d12, d11);
            } while (Math.max(d12, d11) > 0.755591531667601 && 0.034240503750111 * Math.abs(d10) > 0.3989422804 * Math.exp(d9 * d9 / -2.0) - 0.180025191068563 * (2.216035867166471 - Math.abs(d9)));
            d3 = d10 < 0.0 ? d9 : -d9;
        } else if (d4 >= 0.911312780288703) {
            double d13;
            double d14;
            double d15;
            double d16;
            do {
                d16 = randomStream.nextDouble();
                d15 = randomStream.nextDouble();
                d14 = d16 - d15;
                d13 = 0.479727404222441 + 1.10547366102207 * Math.min(d16, d15);
            } while (Math.max(d16, d15) > 0.87283497667179 && 0.049264496373128 * Math.abs(d14) > 0.3989422804 * Math.exp(d13 * d13 / -2.0) - 0.180025191068563 * (2.216035867166471 - Math.abs(d13)));
            d3 = d14 < 0.0 ? d13 : -d13;
        } else {
            double d17;
            double d18;
            double d19;
            double d20;
            do {
                d20 = randomStream.nextDouble();
                d19 = randomStream.nextDouble();
                d18 = d20 - d19;
                d17 = 0.479727404222441 - 0.59550713801594 * Math.min(d20, d19);
                if (!(d17 <= 0.0)) continue;
            } while (Math.max(d20, d19) > 0.805777924423817 && 0.053377549506886 * Math.abs(d18) > 0.3989422804 * Math.exp(d17 * d17 / -2.0) - 0.180025191068563 * (2.216035867166471 - Math.abs(d17)));
            d3 = d18 < 0.0 ? d17 : -d17;
        }
        return d + d2 * d3;
    }
}

