/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javax.realtime.MemoryArea;
import javolution.lang.Reflection;
import javolution.realtime.Context;
import javolution.realtime.ObjectFactory;
import javolution.realtime.ObjectPool;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XmlElement;
import javolution.xml.XmlException;
import javolution.xml.XmlFormat;

public class PoolContext
extends Context {
    protected static final XmlFormat XML = new XmlFormat("javolution.realtime.PoolContext"){

        public void format(Object object, XmlElement xmlElement) {
            PoolContext poolContext = (PoolContext)object;
            FastMap<Class<?>, Integer> fastMap = FastMap.newInstance();
            int n = ObjectFactory.Count;
            while (--n >= 0) {
                int n2 = poolContext._pools[n].size();
                if (n2 <= 0) continue;
                fastMap.put(ObjectFactory.INSTANCES[n].getClass(), new Integer(n2));
            }
            xmlElement.add(fastMap);
        }

        public Object parse(XmlElement xmlElement) {
            PoolContext poolContext = (PoolContext)xmlElement.object();
            FastMap fastMap = (FastMap)xmlElement.getNext();
            FastCollection.Record record = fastMap.head();
            FastMap.Entry entry = fastMap.tail();
            while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                Class clazz = (Class)((FastMap.Entry)record).getKey();
                int n = (Integer)((FastMap.Entry)record).getValue();
                ObjectFactory objectFactory = ObjectFactory.getInstance(clazz);
                if (objectFactory == null) {
                    throw new XmlException("Factory for class " + clazz + " not found");
                }
                ObjectPool objectPool = objectFactory.newPool();
                while (objectPool.size() < n) {
                    objectPool.next();
                }
                objectPool.recycleAll();
                poolContext._pools[objectFactory._index] = objectPool;
            }
            return poolContext;
        }
    };
    private static final Class CLASS = Reflection.getClass("javolution.realtime.PoolContext");
    final ObjectPool[] _pools = new ObjectPool[ObjectFactory.MAX];
    private final ObjectPool[] _inUsePools = new ObjectPool[ObjectFactory.MAX];
    private int _inUsePoolsLength;

    public PoolContext() {
        int n = this._pools.length;
        while (n > 0) {
            this._pools[--n] = ObjectPool.NULL;
        }
    }

    public static PoolContext current() {
        return Context.current().inheritedPoolContext;
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    public void clear() {
        super.clear();
        int n = ObjectFactory.Count;
        while (n > 0) {
            ObjectPool objectPool;
            if ((objectPool = this._pools[--n]) == ObjectPool.NULL) continue;
            objectPool.clearAll();
        }
        this._inUsePoolsLength = 0;
    }

    protected void enterAction() {
        this.inheritedPoolContext = this;
        PoolContext poolContext = this.getOuter().inheritedPoolContext;
        if (poolContext != null) {
            poolContext.setInUsePoolsLocal(false);
        }
    }

    protected void exitAction() {
        this.recyclePools();
        PoolContext poolContext = this.getOuter().inheritedPoolContext;
        if (poolContext != null) {
            poolContext.setInUsePoolsLocal(true);
        }
    }

    void setInUsePoolsLocal(boolean bl) {
        Thread thread = bl ? this.getOwner() : null;
        int n = this._inUsePoolsLength;
        while (n > 0) {
            this._inUsePools[--n].user = thread;
        }
    }

    ObjectPool getLocalPool(int n) {
        ObjectPool objectPool = this._pools[n];
        return objectPool.user != null ? objectPool : this.getLocalPool2(n);
    }

    private ObjectPool getLocalPool2(int n) {
        ObjectPool objectPool = this.getPool(n);
        objectPool.user = this.getOwner();
        return objectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectPool getPool(final int n) {
        ObjectPool objectPool = this._pools[n];
        if (objectPool == ObjectPool.NULL) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    PoolContext.this._pools[n] = ObjectFactory.INSTANCES[n].newPool();
                }
            });
        }
        objectPool = this._pools[n];
        if (!objectPool.inUse) {
            objectPool.inUse = true;
            this._inUsePools[this._inUsePoolsLength++] = objectPool;
            PoolContext poolContext = this.getOuter().inheritedPoolContext;
            if (poolContext != null) {
                PoolContext poolContext2 = poolContext;
                synchronized (poolContext2) {
                    objectPool.outer = poolContext.getPool(n);
                }
            } else {
                objectPool.outer = null;
            }
        }
        return objectPool;
    }

    void recyclePools() {
        int n = this._inUsePoolsLength;
        while (n > 0) {
            ObjectPool objectPool = this._inUsePools[--n];
            objectPool.recycleAll();
            objectPool.user = null;
            objectPool.inUse = false;
        }
        this._inUsePoolsLength = 0;
    }
}

