/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree;

import net.sf.jclec.IConfigure;
import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractRecombinator;
import net.sf.jclec.exprtree.ExprTree;
import net.sf.jclec.exprtree.ExprTreeIndividual;
import net.sf.jclec.exprtree.IExprTreeSpecies;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExprTreeRecombinator<I extends ExprTreeIndividual>
extends AbstractRecombinator<I>
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected transient IExprTreeSpecies<I> species;
    protected transient IExprTreeSpecies.IExprTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
    }

    @Override
    protected void setPpl() {
        this.ppl = 2;
    }

    @Override
    protected void setSpl() {
        this.spl = 2;
    }

    @Override
    protected void prepareRecombination() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof IExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (IExprTreeSpecies)spc;
        this.schema = ((IExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void recombineNext() {
        int nOfExprTrees = this.species.numberOfExprTrees();
        int actTargetExprIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfExprTrees) : this.targetTreeIndex;
        ExprTree[] p0_genotype = (ExprTree[])((ExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter++)).getGenotype();
        ExprTree[] p1_genotype = (ExprTree[])((ExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter++)).getGenotype();
        ExprTree[] s0_genotype = new ExprTree[nOfExprTrees];
        ExprTree[] s1_genotype = new ExprTree[nOfExprTrees];
        int i = 0;
        while (i < nOfExprTrees) {
            s0_genotype[i] = new ExprTree();
            s1_genotype[i] = new ExprTree();
            ++i;
        }
        i = 0;
        while (i < nOfExprTrees) {
            if (i == actTargetExprIndex) {
                this.recombine(p0_genotype[i], p1_genotype[i], s0_genotype[i], s1_genotype[i], this.schema[i]);
            } else {
                s0_genotype[i] = p0_genotype[i].copy();
                s1_genotype[i] = p1_genotype[i].copy();
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(s0_genotype));
        this.sonsBuffer.add(this.species.createIndividual(s1_genotype));
    }

    protected abstract void recombine(ExprTree var1, ExprTree var2, ExprTree var3, ExprTree var4, IExprTreeSpecies.IExprTreeSchema var5);
}

