/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms;

import keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.Cromosoma;
import org.core.Randomize;

public class CromosomaEntero
extends Cromosoma {
    private int numCaracteristicas;

    public CromosomaEntero(int numCaracs, int tam) {
        super(tam);
        this.numCaracteristicas = numCaracs;
    }

    @Override
    public void initRand() {
        int temp = 0;
        for (int i = 0; i < this.tamCromosoma; ++i) {
            int j = -1;
            while (j != i) {
                temp = Randomize.Randint(0, this.numCaracteristicas);
                for (j = 0; j < i && this.rep[j] != temp; ++j) {
                }
            }
            this.rep[i] = temp;
        }
    }

    @Override
    public void initPlantilla(Cromosoma crPlantilla, double ratio) {
        int i;
        int temp = 0;
        for (i = 0; i < this.tamCromosoma; ++i) {
            this.rep[i] = Randomize.RandClosed() <= ratio ? crPlantilla.devolverGen(i) : -1;
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            int j = -1;
            while (j != i) {
                temp = Randomize.Randint(0, this.numCaracteristicas);
                for (j = 0; j < this.tamCromosoma && this.rep[j] != temp; ++j) {
                }
            }
            this.rep[i] = temp;
        }
    }

    @Override
    public int devolverGen(int i) {
        if (i < 0 || i >= this.tamCromosoma) {
            System.err.println("ERROR: Gen i is out of chromosome bounds");
            System.exit(0);
        }
        return this.rep[i];
    }

    @Override
    public void cambiarGen(int nuevoValorGen, int posGen) {
        int j;
        if (posGen < 0 || posGen >= this.rep.length) {
            System.err.println("ERROR: Gen 'posGen' is out of bounds");
            System.exit(0);
        }
        if (nuevoValorGen < 0) {
            System.err.println("ERROR: The new value for gen doesn't correct. It must be greater than -1 & less than numFeatures-1");
            System.exit(0);
        }
        for (j = 0; j < this.rep.length && this.rep[j] != nuevoValorGen; ++j) {
        }
        if (j == this.rep.length) {
            this.rep[posGen] = nuevoValorGen;
        } else {
            System.err.println("ERROR: New value for chromosome is incorrect. This value already exists");
            System.exit(0);
        }
    }

    @Override
    public void cruzar(Cromosoma padre2, Cromosoma hijo1, Cromosoma hijo2) {
        int j;
        int i;
        int puntoCorte2;
        int puntoCorte1;
        int temp = 0;
        if (padre2 == null) {
            System.err.println("ERROR: padre2 doesn't exist");
            System.exit(0);
        }
        while ((puntoCorte1 = Randomize.Randint(0, this.tamCromosoma)) >= (puntoCorte2 = Randomize.Randint(0, this.tamCromosoma))) {
        }
        int[] vectorAux = new int[this.tamCromosoma];
        for (i = 0; i < this.tamCromosoma; ++i) {
            vectorAux[i] = -1;
        }
        for (i = puntoCorte1; i < puntoCorte2; ++i) {
            vectorAux[i] = this.rep[i];
        }
        int pos = puntoCorte2;
        for (i = puntoCorte2; i < this.tamCromosoma; ++i) {
            temp = padre2.devolverGen(i);
            for (j = 0; j < i && vectorAux[j] != temp; ++j) {
            }
            if (j != i) continue;
            vectorAux[pos++] = temp;
        }
        for (i = 0; i < puntoCorte1; ++i) {
            temp = padre2.devolverGen(i);
            for (j = i + 1; j < this.tamCromosoma && vectorAux[j] != temp; ++j) {
            }
            if (j != this.tamCromosoma) continue;
            if (pos == this.tamCromosoma) {
                pos = 0;
            }
            vectorAux[pos++] = temp;
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            if (vectorAux[i] != -1) continue;
            j = 0;
            while (j != this.tamCromosoma) {
                temp = Randomize.Randint(0, this.numCaracteristicas);
                for (j = 0; j < this.tamCromosoma && vectorAux[j] != temp; ++j) {
                }
            }
            vectorAux[i] = temp;
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            hijo1.cambiarGen(vectorAux[i], i);
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            vectorAux[i] = -1;
        }
        for (i = puntoCorte1; i < puntoCorte2; ++i) {
            vectorAux[i] = padre2.devolverGen(i);
        }
        pos = puntoCorte2;
        for (i = puntoCorte2; i < this.tamCromosoma; ++i) {
            temp = this.rep[i];
            for (j = 0; j < i && vectorAux[j] != temp; ++j) {
            }
            if (j != i) continue;
            vectorAux[pos++] = temp;
        }
        for (i = 0; i < puntoCorte1; ++i) {
            temp = this.rep[i];
            for (j = i + 1; j < this.tamCromosoma && vectorAux[j] != temp; ++j) {
            }
            if (j != this.tamCromosoma) continue;
            if (pos == this.tamCromosoma) {
                pos = 0;
            }
            vectorAux[pos++] = temp;
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            if (vectorAux[i] != -1) continue;
            j = 0;
            while (j != this.tamCromosoma) {
                temp = Randomize.Randint(0, this.numCaracteristicas);
                for (j = 0; j < this.tamCromosoma && vectorAux[j] != temp; ++j) {
                }
            }
            vectorAux[i] = temp;
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            hijo2.cambiarGen(vectorAux[i], i);
        }
    }

    @Override
    public boolean cruzarHUX(Cromosoma padre2, Cromosoma hijo1, Cromosoma hijo2, int umbral) {
        return false;
    }

    @Override
    public void mutar() {
        int puntoAleat = Randomize.Randint(0, this.tamCromosoma);
        int temp = 0;
        this.rep[puntoAleat] = -1;
        int j = -1;
        while (j != this.tamCromosoma) {
            temp = Randomize.Randint(0, this.numCaracteristicas);
            for (j = 0; j < this.tamCromosoma && this.rep[j] != temp; ++j) {
            }
        }
        this.rep[puntoAleat] = temp;
        this.fitness = -1.0;
    }

    @Override
    public String print() {
        String res = new String();
        for (int i = 0; i < this.tamCromosoma; ++i) {
            res = res + "Gen " + String.valueOf(i + 1) + ": Value " + String.valueOf(this.rep[i]) + "\n";
        }
        return res;
    }

    @Override
    public boolean[] devolverFeaturesVector() {
        int i;
        boolean[] featuresVector = new boolean[this.numCaracteristicas];
        for (i = 0; i < this.numCaracteristicas; ++i) {
            featuresVector[i] = false;
        }
        for (i = 0; i < this.tamCromosoma; ++i) {
            featuresVector[this.rep[i]] = true;
        }
        return featuresVector;
    }
}

