/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Prism;

import java.util.LinkedList;
import keel.Algorithms.Rule_Learning.Prism.Complejo;
import keel.Algorithms.Rule_Learning.Prism.Selector;

public class ConjReglas {
    private LinkedList reglas = new LinkedList();
    private String nombreClase;
    private String[] valorNombreClases;

    public void addReglas(ConjReglas r) {
        for (int i = 0; i < r.size(); ++i) {
            Complejo regla = r.getRegla(i);
            this.reglas.add(regla);
        }
    }

    public void addRegla(Complejo regl) {
        this.reglas.add(regl);
    }

    public void deleteRegla(int i) {
        this.reglas.remove(i);
    }

    public void deleteAll() {
        this.reglas.removeAll(this.reglas);
    }

    public Complejo getRegla(int i) {
        return (Complejo)this.reglas.get(i);
    }

    public int size() {
        return this.reglas.size();
    }

    public LinkedList getConjReglas() {
        return this.reglas;
    }

    public void print() {
        for (int i = 0; i < this.reglas.size(); ++i) {
            Complejo c = (Complejo)this.reglas.get(i);
            System.out.print("\nRule " + (i + 1) + ": IF  ");
            c.print();
            System.out.print(" THEN " + this.nombreClase + " -> " + this.valorNombreClases[c.getClase()] + "  ");
            c.printDistribucion();
        }
    }

    public String printString() {
        String cad = "";
        for (int i = 0; i < this.reglas.size(); ++i) {
            Complejo c = (Complejo)this.reglas.get(i);
            cad = cad + "\nRule " + (i + 1) + ": IF  ";
            cad = cad + c.printString();
            cad = cad + " THEN " + this.nombreClase + " -> " + this.valorNombreClases[c.getClase()] + "  ";
            cad = cad + c.printDistribucionString();
        }
        return cad;
    }

    public Complejo getUltimaRegla() {
        return (Complejo)this.reglas.getLast();
    }

    public void eliminaNulos() {
        for (int i = 0; i < this.size(); ++i) {
            Complejo aux = this.getRegla(i);
            boolean salir = false;
            for (int j = 0; j < aux.size() - 1 && !salir; ++j) {
                Selector s = aux.getSelector(j);
                for (int h = j + 1; h < aux.size() && !salir; ++h) {
                    Selector s2 = aux.getSelector(h);
                    if (s.compareTo(s2) >= 2) continue;
                    this.deleteRegla(i);
                    salir = true;
                    --i;
                }
            }
        }
    }

    public void eliminaRepetidos(int tam) {
        for (int i = 0; i < this.size() - 1; ++i) {
            Complejo aux = this.getRegla(i);
            boolean seguir = true;
            for (int j = i + 1; j < this.size() && seguir; ++j) {
                Complejo aux2 = this.getRegla(j);
                boolean parar = false;
                for (int l = 0; l < aux.size() && !parar; ++l) {
                    Selector s = aux.getSelector(l);
                    boolean salir = false;
                    for (int h = 0; h < aux2.size() && !salir; ++h) {
                        Selector s2 = aux2.getSelector(h);
                        if (s.compareTo(s2) != 0) continue;
                        salir = true;
                        if (l != aux.size() - 1) continue;
                        seguir = false;
                        this.deleteRegla(i);
                        --i;
                    }
                    parar = !salir;
                }
            }
        }
    }

    public void eliminaSubsumidos(int tam) {
        for (int i = 0; i < tam; ++i) {
            Complejo aux = this.getRegla(i);
            boolean seguir = true;
            for (int j = i + 1; j < this.size() && seguir; ++j) {
                Complejo aux2 = this.getRegla(j);
                seguir = false;
                boolean parar = false;
                for (int l = 0; l < aux.size() && !parar; ++l) {
                    Selector s = aux.getSelector(l);
                    boolean salir = false;
                    for (int h = 0; h < aux2.size() && !salir; ++h) {
                        Selector s2 = aux2.getSelector(h);
                        if (s.compareTo(s2) != -3 && s.compareTo(s2) != 0) continue;
                        salir = true;
                        if (l != aux.size() - 1 || aux.getDistribucionClase(0) != aux2.getDistribucionClase(0)) continue;
                        seguir = false;
                        this.deleteRegla(i);
                        --i;
                    }
                    parar = !salir;
                }
            }
        }
    }

    public void adjuntaNombreClase(String nombreClase) {
        this.nombreClase = nombreClase;
    }

    public void adjuntaNombreClases(String[] clases) {
        this.valorNombreClases = new String[clases.length];
        for (int i = 0; i < clases.length; ++i) {
            this.valorNombreClases[i] = clases[i];
        }
    }
}

