/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.realarray.mut;

import net.sf.jclec.realarray.RealArrayIndividual;
import net.sf.jclec.realarray.mut.ModalMutator;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModalDiscreteMutator<I extends RealArrayIndividual>
extends ModalMutator<I> {
    private static final long serialVersionUID = -617036782103757330L;

    @Override
    public void setBm(double bm) {
        this.Bm = bm > 1.0 ? bm : 2.0;
    }

    public boolean equals(Object other) {
        if (other instanceof ModalDiscreteMutator) {
            ModalDiscreteMutator o = (ModalDiscreteMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusMutProb, o.locusMutProb);
            eb.append(this.Bm, o.Bm);
            eb.append(this.minimumRange, o.minimumRange);
            eb.append(this.mutationRange, o.mutationRange);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doLocusMutation(double[] parentChromosome, double[] mutantChromosome, int locusIndex) {
        double rang = this.mutationRange * this.genotypeSchema[locusIndex].efWidth();
        int pi = (int)(Math.log(this.minimumRange) / Math.log(this.Bm));
        double gamma = 0.0;
        int k = 0;
        while (k >= pi) {
            gamma += (double)(this.randgen.raw() < 0.0625 ? 1 : 0) * Math.pow(this.Bm, k);
            --k;
        }
        double newValue = this.randgen.coin() ? parentChromosome[locusIndex] + rang * gamma : parentChromosome[locusIndex] - rang * gamma;
        mutantChromosome[locusIndex] = this.genotypeSchema[locusIndex].nearestOf(newValue);
    }

    @Override
    protected double defaultLocusMutProb() {
        return 0.6;
    }

    @Override
    protected double defaultBm() {
        return 2.0;
    }

    @Override
    protected double defaultMutationRange() {
        return 0.1;
    }

    @Override
    protected double defaultMinimumRange() {
        return 1.0E-5;
    }
}

