## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----message=FALSE, warning=FALSE---------------------------------------------

# load the library
library(highlightr)

# rename the column of interest to page_notes
comment_example_rename <- dplyr::rename(comment_example, page_notes=Notes)

# tokenize comments
toks_comment <- token_comments(comment_example_rename)

## ----message=FALSE, warning=FALSE---------------------------------------------

# rename column of interest for the source document to 'text'
transcript_example_rename <- dplyr::rename(transcript_example, text=Text)

# tokenize source document
toks_transcript <- token_transcript(transcript_example_rename)

## ----message=FALSE, warning=FALSE---------------------------------------------

# use fuzzy collocation on source and derivative tokenized documents

collocation_object <- collocate_comments_fuzzy(toks_transcript, toks_comment)

head(collocation_object)


## ----message=FALSE, warning=FALSE---------------------------------------------

# connect collocation frequencies to source document

merged_frequency <- transcript_frequency(transcript_example_rename, collocation_object)

## ----message=FALSE, warning=FALSE---------------------------------------------

# create `ggplot` object of the transcript

freq_plot <- collocation_plot(merged_frequency)

## ----message=FALSE, warning=FALSE---------------------------------------------

# add html tags to source document

page_highlight <- highlighted_text(freq_plot)


## ----message=FALSE, warning=FALSE, eval=FALSE---------------------------------
# 
# # load `xml2` library
# 
# library(xml2)
# 
# # save html output to desired location
# 
# xml2::write_html(xml2::read_html(page_highlight), "filename.html")
# 

## ----message=FALSE, warning=FALSE---------------------------------------------

# use nonfuzzy collocation on the source and derivative tokenized texts

collocation_object_nonfuzzy <- collocate_comments(toks_transcript, toks_comment)

head(collocation_object_nonfuzzy)


## ----message=FALSE, warning=FALSE---------------------------------------------

# connect collocation frequencies to source document

merged_frequency_nonfuzzy <- transcript_frequency(transcript_example_rename, collocation_object_nonfuzzy)

# create a `ggplot` object of the transcript, and change colors of the gradient

freq_plot_nonfuzzy <- collocation_plot(merged_frequency_nonfuzzy, colors=c("#15bf7e", "#fcc7ed"))

# add html tags to source document

page_highlight_nonfuzzy <- highlighted_text(freq_plot_nonfuzzy)

## ----message=FALSE, warning=FALSE---------------------------------------------

# use nonfuzzy collocations with a collocation length of 2

collocation_object_2col <- collocate_comments(toks_transcript, toks_comment, collocate_length = 2)

head(collocation_object_2col, n=7)


## ----message=FALSE, warning=FALSE---------------------------------------------

# connect collocation frequencies to source document

merged_frequency_2col <- transcript_frequency(transcript_example_rename, collocation_object_2col)

# create a `ggplot` object of the transcript

freq_plot_2col <- collocation_plot(merged_frequency_2col)

# add html tags to source document

page_highlight_2col <- highlighted_text(freq_plot_2col)

