#' Create a capability chart for statistical process control
#' 
#' @description
#' Generate a histogram type chart from a set of consecutive measurements.
#' 
#' @details
#' This type of chart is typically applied in product manufacturing to monitor
#' deviations from the target value over time. It is usually accompanied by 
#' the statistical process control time series \code{\link{chart_I}} and 
#' \code{\link{chart_IMR}}
#' 
#' @references 
#' For a complete case study application refer to \url{https://j-ramalho.github.io/industRial/}
#'
#' @param data
#' A dataset generated by the function \code{\link{process_stats}}
#'
#' @return
#' This function returns an object of class ggplot
#' @export
#'
#' @examples
chart_Cpk <- function(data) {
  data %>%
    ggplot2::ggplot() +
    ggplot2::geom_histogram(
      ggplot2::aes(x = weight_value, y = ..count..),
      fill = "grey80",
      color = "grey20") +
    ggplot2::geom_vline(ggplot2::aes(xintercept = spec_min), color = "red", linetype = 3) +
    ggplot2::geom_vline(ggplot2::aes(xintercept = spec_max), color = "red", linetype = 3) +
    ggplot2::geom_vline(ggplot2::aes(xintercept = weight_target_value), color = "red", linetype = 2) +
    ggplot2::theme_light() +
    ggplot2::labs(
      title = "Tablet weight process control",
      subtitle = "Process Capability chart",
      x = "Part Weight [g]",
      y = "Count",
      caption = "data source: Line1"
    ) +
    theme_qcc()
}