/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.SumLattice;
import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class OneLabelL2RangeGEConstraints
implements GEConstraint {
    protected IntObjectHashMap<OneLabelL2IndGEConstraint> constraints;
    protected StateLabelMap map;
    protected IntArrayList cache;

    public OneLabelL2RangeGEConstraints() {
        this.constraints = new IntObjectHashMap();
        this.cache = new IntArrayList();
    }

    protected OneLabelL2RangeGEConstraints(IntObjectHashMap<OneLabelL2IndGEConstraint> constraints, StateLabelMap map) {
        this.constraints = constraints;
        this.map = map;
        this.cache = new IntArrayList();
    }

    public void addConstraint(int fi, int li, double lower, double upper, double weight) {
        if (!this.constraints.containsKey(fi)) {
            this.constraints.put(fi, new OneLabelL2IndGEConstraint());
        }
        this.constraints.get(fi).add(li, lower, upper, weight);
    }

    @Override
    public boolean isOneStateConstraint() {
        return true;
    }

    @Override
    public void setStateLabelMap(StateLabelMap map) {
        this.map = map;
    }

    @Override
    public void preProcess(FeatureVector fv) {
        this.cache.clear();
        for (int loc = 0; loc < fv.numLocations(); ++loc) {
            int fi = fv.indexAtLocation(loc);
            if (!this.constraints.containsKey(fi)) continue;
            this.cache.add(fi);
        }
        if (this.constraints.containsKey(fv.getAlphabet().size())) {
            this.cache.add(fv.getAlphabet().size());
        }
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        int ii = 0;
        BitSet bitSet = new BitSet(data.size());
        for (Instance instance : data) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)instance.getData();
            for (int ip = 0; ip < fvs.size(); ++ip) {
                FeatureVector fv = fvs.get(ip);
                for (int loc = 0; loc < fv.numLocations(); ++loc) {
                    int fi = fv.indexAtLocation(loc);
                    if (!this.constraints.containsKey(fi)) continue;
                    this.constraints.get((int)fi).count += 1.0;
                    bitSet.set(ii);
                }
                if (!this.constraints.containsKey(fv.getAlphabet().size())) continue;
                bitSet.set(ii);
                this.constraints.get((int)fv.getAlphabet().size()).count += 1.0;
            }
            ++ii;
        }
        return bitSet;
    }

    @Override
    public double getCompositeConstraintFeatureValue(FeatureVector fv, int ip, int si1, int si2) {
        double value = 0.0;
        int li2 = this.map.getLabelIndex(si2);
        for (int i = 0; i < this.cache.size(); ++i) {
            value += this.constraints.get(this.cache.get(i)).getGradientContribution(li2);
        }
        return value;
    }

    @Override
    public double getValue() {
        double value = 0.0;
        for (ObjectCursor fi : this.constraints.values()) {
            OneLabelL2IndGEConstraint constraint = (OneLabelL2IndGEConstraint)fi.value;
            if (!(constraint.count > 0.0)) continue;
            for (int labelIndex = 0; labelIndex < this.map.getNumLabels(); ++labelIndex) {
                value -= constraint.getValueContribution(labelIndex);
            }
        }
        assert (!Double.isNaN(value) && !Double.isInfinite(value));
        return value;
    }

    @Override
    public void zeroExpectations() {
        for (ObjectCursor fi : this.constraints.values()) {
            ((OneLabelL2IndGEConstraint)fi.value).expectation = new double[((OneLabelL2IndGEConstraint)fi.value).getNumConstrainedLabels()];
        }
    }

    @Override
    public void computeExpectations(ArrayList<SumLattice> lattices) {
        IntArrayList cache = new IntArrayList();
        for (int i = 0; i < lattices.size(); ++i) {
            if (lattices.get(i) == null) continue;
            SumLattice lattice = lattices.get(i);
            FeatureVectorSequence fvs = (FeatureVectorSequence)lattice.getInput();
            double[][] gammas = lattice.getGammas();
            for (int ip = 0; ip < fvs.size(); ++ip) {
                cache.clear();
                FeatureVector fv = fvs.getFeatureVector(ip);
                for (int loc = 0; loc < fv.numLocations(); ++loc) {
                    int fi = fv.indexAtLocation(loc);
                    if (!this.constraints.containsKey(fi)) continue;
                    cache.add(fi);
                }
                if (this.constraints.containsKey(fv.getAlphabet().size())) {
                    cache.add(fv.getAlphabet().size());
                }
                for (int s = 0; s < this.map.getNumStates(); ++s) {
                    int li = this.map.getLabelIndex(s);
                    if (li == -2) continue;
                    double gammaProb = Math.exp(gammas[ip + 1][s]);
                    for (int j = 0; j < cache.size(); ++j) {
                        this.constraints.get(cache.get(j)).incrementExpectation(li, gammaProb);
                    }
                }
            }
        }
    }

    @Override
    public GEConstraint copy() {
        return new OneLabelL2RangeGEConstraints(this.constraints, this.map);
    }

    protected class OneLabelL2IndGEConstraint {
        protected int index = 0;
        protected double count = 0.0;
        protected ArrayList<Double> lower = new ArrayList();
        protected ArrayList<Double> upper = new ArrayList();
        protected ArrayList<Double> weights = new ArrayList();
        protected HashMap<Integer, Integer> labelMap = new HashMap();
        protected double[] expectation;

        public void add(int label, double lower, double upper, double weight) {
            this.lower.add(lower);
            this.upper.add(upper);
            this.weights.add(weight);
            this.labelMap.put(label, this.index);
            ++this.index;
        }

        public void incrementExpectation(int li, double value) {
            if (this.labelMap.containsKey(li)) {
                int i;
                int n = i = this.labelMap.get(li).intValue();
                this.expectation[n] = this.expectation[n] + value;
            }
        }

        public double getValueContribution(int li) {
            if (this.labelMap.containsKey(li)) {
                int i = this.labelMap.get(li);
                assert (this.count != 0.0);
                double ex = this.expectation[i] / this.count;
                if (ex < this.lower.get(i)) {
                    return this.weights.get(i) * Math.pow(this.lower.get(i) - ex, 2.0);
                }
                if (ex > this.upper.get(i)) {
                    return this.weights.get(i) * Math.pow(this.upper.get(i) - ex, 2.0);
                }
            }
            return 0.0;
        }

        public int getNumConstrainedLabels() {
            return this.index;
        }

        public double getGradientContribution(int li) {
            if (this.labelMap.containsKey(li)) {
                int i = this.labelMap.get(li);
                assert (this.count != 0.0);
                double ex = this.expectation[i] / this.count;
                if (ex < this.lower.get(i)) {
                    return 2.0 * this.weights.get(i) * (this.lower.get(i) / this.count - this.expectation[i] / (this.count * this.count));
                }
                if (ex > this.upper.get(i)) {
                    return 2.0 * this.weights.get(i) * (this.upper.get(i) / this.count - this.expectation[i] / (this.count * this.count));
                }
            }
            return 0.0;
        }
    }
}

