/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.session;

import com.qarks.util.ObjectUID;
import com.qarks.util.session.SessionListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class SessionHandle {
    private long mTimeout;
    private long mLastAccessTime;
    private Map<String, Object> mContent = new Hashtable<String, Object>();
    private Vector mListeners = new Vector(10);
    public ObjectUID mObjectUID = null;

    public SessionHandle() {
        this.mTimeout = Integer.MAX_VALUE;
    }

    public SessionHandle(long l) {
        this.mTimeout = l;
    }

    public void setObjectUID(ObjectUID objectUID) {
        this.mObjectUID = objectUID;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public ObjectUID getObjectUID() {
        return this.mObjectUID;
    }

    public synchronized long getLastAccessTime() {
        return this.mLastAccessTime;
    }

    public Object getContent(String string) {
        this.resetTimeout();
        return this.mContent.get(string);
    }

    public void setContent(String string, Object object) {
        this.mContent.put(string, object);
        this.resetTimeout();
    }

    public void resetTimeout() {
        this.mLastAccessTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExpiration() {
        Vector vector;
        Vector vector2 = this.mListeners;
        synchronized (vector2) {
            vector = (Vector)this.mListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            SessionListener sessionListener = (SessionListener)vector.elementAt(i);
            sessionListener.onSessionExpired(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener sessionListener) {
        Vector vector = this.mListeners;
        synchronized (vector) {
            this.mListeners.addElement(sessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener sessionListener) {
        Vector vector = this.mListeners;
        synchronized (vector) {
            this.mListeners.removeElement(sessionListener);
        }
    }
}

