
CaptureOutput <- function(..., comment = "## ", print = TRUE) {
  zz <- textConnection("output", "w")
  capture.output(..., file = zz)
  close(zz)
  ret <- paste(paste("## ", output, sep = ""), collapse = "\n")
  if (print) cat(ret)
  invisible(ret)
} 


### Generate test cases for p-variation

x <- structure(c(0, -0.0740075184021381, -0.0670053233078347, -0.161930321876744, 
                -0.0137643789908698, 0.00782426086276139, -0.0855847148769449, 
                -0.0482039469620012, 0.0142663862230157, 0.0604823840604601, 
                0.0185814080169197, 0.1583973875341, 0.186019573847338, 0.112533378465253, 
                -0.120298747580402, -0.019167793093996, -0.0350232913234239, 
                -0.0480044549612233, 0.0350170287794018, 0.105777010961306, 0.153805005755152, 
                0.234340605588069, 0.301192098333271, 0.297286459341885, 0.086989152427643, 
                0.137609589889209, 0.120634578608404, 0.0936928906099665, -0.0647444851078657, 
                -0.123921627946633, -0.0934896092545671, 0.0310162085704325, 
                0.00937529850822805, 0.0367803223362602, 0.0200376809500649, 
                -0.129030412060701, -0.181892005718573, -0.232683138417513, -0.249976615416537, 
                -0.151336215546053, -0.0863807780282035, -0.114195274981467, 
                -0.150893580323022, -0.0925593801104536, -0.0482551975709927, 
                -0.128492904353849, -0.210604557377966, -0.185508498492188, -0.120017343368551, 
                -0.142614101911479, -0.0658654665939622, -0.0374170158851602, 
                -0.109981792538142, -0.0872319607236045, -0.211530407659589, 
                -0.0795901748173897, 0.107087677705291, 0.0590033927307357, -0.056772207228822, 
                -0.0111623818124856, -0.0360299795284729, 0.1927696591941, 0.177483521592878, 
                0.235095320510051, 0.226533399060213, 0.140843940844067, 0.148361033467597, 
                -0.0434969667494116, 0.0916963820789721, 0.0956595785722572, 
                0.301558608280568, 0.337747423842629, 0.255390643422543, 0.305101141443543, 
                0.200329240951214, 0.0636037635993986, 0.0813862498232399, 0.0256949251734919, 
                0.0144433230087495, 0.0105153180960109, -0.059798913850701, -0.128027924460456, 
                -0.152907923300744, -0.0464613609713285, -0.210180178342209, 
                -0.162147696907272, -0.140214797113825, -0.0452669507140935, 
                -0.0870474804054285, -0.0614077367417044, -0.0460599949923862, 
                -0.111674135419456, -0.00224949214904369, 0.102428632092547, 
                0.161087859716142, 0.308409067842321, 0.352895573070947, 0.213874214897239, 
                0.145185536145645, 0.0113621373279049, -0.0473400636439312), .Tsp = c(0, 
                                                                        1, 100), class = "ts")
GTC <- function(){
  
  arglist <- expand.grid(p=seq(0.5,5,0.5),LSI=seq(1,15,2))
  arglist <- split(arglist, rownames(arglist))
  caselist <- list()
  for(i in seq_along(arglist)){
    argsput <- as.list(arglist[[i]])
    argsput$x <- x
    argsput$TimeLabel <- seq_along(x)  
    result=do.call("pvar", argsput)
    caselist[[i]] <- list(input = argsput, output = result)
    caselist[[i]]$summary <- summary(result)
    caselist[[i]]$summary.print <- CaptureOutput(caselist[[i]]$summary, comment="", print=FALSE)
    caselist[[i]]$output.print <- CaptureOutput(caselist[[i]]$output, comment="", print=FALSE)
  }
  
  # save(caselist, CaptureOutput, file="inst/extdata/caselist.RData")

}









