/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;

public class QuickXPlain {
    private final Model model;

    public QuickXPlain(Model model) {
        this.model = model;
    }

    public List<Constraint> findMinimumConflictingSet(List<Constraint> conflictingSet) {
        List<Constraint> allConstraints = this.getAllConstraints();
        List<Constraint> background = this.getBackground(allConstraints, conflictingSet);
        List<Constraint> minimumConflictSet = conflictingSet.isEmpty() || this.isConsistent(allConstraints) ? Collections.emptyList() : this.qx(background, background, conflictingSet);
        this.model.getSolver().reset();
        return minimumConflictSet;
    }

    private List<Constraint> qx(List<Constraint> background, List<Constraint> conflict, List<Constraint> constraints) {
        if (!conflict.isEmpty() && !this.isConsistent(background)) {
            return Collections.emptyList();
        }
        if (constraints.size() == 1) {
            return constraints;
        }
        int k = constraints.size() / 2;
        ArrayList<Constraint> c1 = new ArrayList<Constraint>(constraints.subList(0, k));
        ArrayList<Constraint> c2 = new ArrayList<Constraint>(constraints.subList(k, constraints.size()));
        ArrayList<Constraint> prevB = new ArrayList<Constraint>(background);
        List<Constraint> d2 = this.qx(this.constraintsUnion(background, c1), c1, c2);
        ArrayList<Constraint> conflictSet = new ArrayList<Constraint>(d2);
        List<Constraint> d1 = this.qx(this.constraintsUnion(prevB, d2), d2, c1);
        HashSet<Constraint> constraintSetHash = new HashSet<Constraint>(conflictSet);
        for (int i = 0; i < d1.size(); ++i) {
            if (constraintSetHash.contains(d1.get(i))) continue;
            conflictSet.add(d1.get(i));
        }
        return conflictSet;
    }

    private boolean isConsistent(List<Constraint> background) {
        this.model.getSolver().reset();
        HashSet<Constraint> constraintsHash = new HashSet<Constraint>(background);
        Constraint[] constraints = this.model.getCstrs();
        for (int i = 0; i < constraints.length; ++i) {
            constraints[i].setEnabled(constraintsHash.contains(constraints[i]));
        }
        return this.model.getSolver().solve();
    }

    public List<Constraint> constraintsUnion(List<Constraint> c1, List<Constraint> c2) {
        c1.addAll(c2);
        return c1;
    }

    private List<Constraint> getBackground(List<Constraint> allConstraints, List<Constraint> conflictingSet) {
        ArrayList<Constraint> knowledgeBase = new ArrayList<Constraint>(allConstraints.size() - conflictingSet.size());
        HashSet<Constraint> conflictSetHash = new HashSet<Constraint>(conflictingSet);
        for (Constraint cstr : allConstraints) {
            if (conflictSetHash.contains(cstr)) continue;
            knowledgeBase.add(cstr);
        }
        return knowledgeBase;
    }

    private List<Constraint> getAllConstraints() {
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>(this.model.getNbCstrs());
        Constraint[] cstrs = this.model.getCstrs();
        Collections.addAll(allConstraints, cstrs);
        return allConstraints;
    }
}

