/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ValidityPeriod {
    public static final ValidityPeriod ALWAYS = new ValidityPeriod(LocalDate.MIN, LocalDate.MAX);
    private final LocalDate start;
    private final LocalDate end;

    public static ValidityPeriod from(LocalDate date) {
        return date == null ? ALWAYS : new ValidityPeriod(date, LocalDate.MAX);
    }

    public static ValidityPeriod to(LocalDate date) {
        return date == null ? ALWAYS : new ValidityPeriod(LocalDate.MIN, date);
    }

    public static ValidityPeriod between(LocalDate date0, LocalDate date1) {
        if (date0 == null) {
            return ValidityPeriod.to(date1);
        }
        if (date1 == null) {
            return ValidityPeriod.from(date0);
        }
        if (date0.equals(LocalDate.MIN) && date1.equals(LocalDate.MAX)) {
            return ALWAYS;
        }
        return new ValidityPeriod(date0, date1);
    }

    public boolean isStartSpecified() {
        return this.start != LocalDate.MIN;
    }

    public boolean isEndSpecified() {
        return this.end != LocalDate.MAX;
    }

    @Generated
    public LocalDate getStart() {
        return this.start;
    }

    @Generated
    public LocalDate getEnd() {
        return this.end;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidityPeriod)) {
            return false;
        }
        ValidityPeriod other = (ValidityPeriod)o;
        LocalDate this$start = this.getStart();
        LocalDate other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDate this$end = this.getEnd();
        LocalDate other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDate $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ValidityPeriod(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }

    @Generated
    private ValidityPeriod(LocalDate start, LocalDate end) {
        this.start = start;
        this.end = end;
    }
}

