/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfErrors;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfMeasurements;

public class Measurements
implements ISsfMeasurements {
    private final ISsfLoading[] loadings;
    private final ISsfErrors measurementsError;

    public static Measurements of(ISsfLoading[] loadings, ISsfErrors measurementsError) {
        return new Measurements(loadings, measurementsError);
    }

    Measurements(ISsfLoading[] loadings, ISsfErrors measurementsError) {
        this.loadings = loadings;
        this.measurementsError = measurementsError;
    }

    @Override
    public int getCount() {
        return this.loadings.length;
    }

    @Override
    public ISsfLoading loading(int equation) {
        return this.loadings[equation];
    }

    @Override
    public ISsfErrors errors() {
        return this.measurementsError;
    }

    @Override
    public boolean isTimeInvariant() {
        if (this.measurementsError != null && !this.measurementsError.isTimeInvariant()) {
            return false;
        }
        for (int i = 0; i < this.loadings.length; ++i) {
            if (this.loadings[i].isTimeInvariant()) continue;
            return false;
        }
        return true;
    }
}

