/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Utilities;
import dag.Dag;
import dag.LinkageEquilibriumDag;
import dag.MergeableDag;
import haplotype.BasicHapPairs;
import haplotype.HapPair;
import haplotype.HapPairs;
import haplotype.RevHapPairs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import main.CurrentData;
import main.GenotypeValues;
import main.Par;
import main.RevGenotypeValues;
import main.RunStats;
import sample.ConsumeSingleSamples;
import sample.SingleBaum;
import vcf.GL;
import vcf.RevGL;

public final class HapPairSampler {
    private final Par par;
    private final RunStats runStats;

    public HapPairSampler(Par par, RunStats runStats) {
        if (par == null) {
            throw new IllegalArgumentException("par==null");
        }
        if (runStats == null) {
            throw new IllegalArgumentException("runStats==null");
        }
        this.par = par;
        this.runStats = runStats;
    }

    public List<HapPair> initialHaps(CurrentData currentData) {
        GL gL = currentData.targetGL();
        GL gL2 = currentData.targetGL();
        boolean bl = false;
        float f = 1.0E-4f;
        LinkageEquilibriumDag linkageEquilibriumDag = new LinkageEquilibriumDag(gL, f);
        ArrayList<HapPair> arrayList = new ArrayList();
        arrayList = Collections.synchronizedList(arrayList);
        this.sample(linkageEquilibriumDag, gL2, bl, this.par.nsamples(), arrayList, this.par.nthreads());
        return new ArrayList<HapPair>(arrayList);
    }

    public List<HapPair> sample(CurrentData currentData, List<HapPair> list, boolean bl, GenotypeValues genotypeValues) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("hapPairs.isEmpty()");
        }
        int n = this.par.nthreads();
        int n2 = this.par.nsamples() * currentData.nTargetSamples();
        GL gL = this.gl(currentData, bl);
        Dag dag = this.getDagsAndUpdatePos(currentData, list, bl);
        List<HapPair> list2 = HapPairSampler.synchronizedEmptyList(n2);
        if (genotypeValues != null) {
            if (bl) {
                genotypeValues = new RevGenotypeValues(genotypeValues);
            }
            this.sample(dag, gL, bl, this.par.nsamples(), list2, genotypeValues, n);
        } else {
            this.sample(dag, gL, bl, this.par.nsamples(), list2, n);
        }
        return new ArrayList<HapPair>(list2);
    }

    private GL gl(CurrentData currentData, boolean bl) {
        GL gL = currentData.targetGL();
        if (bl) {
            gL = new RevGL(gL);
        }
        return gL;
    }

    private static List<HapPair> synchronizedEmptyList(int n) {
        ArrayList<HapPair> arrayList = new ArrayList(n);
        arrayList = Collections.synchronizedList(arrayList);
        return arrayList;
    }

    private Dag getDagsAndUpdatePos(CurrentData currentData, List<HapPair> list, boolean bl) {
        currentData.addRestrictedRefHapPairs(list);
        HapPairs hapPairs = new BasicHapPairs(list);
        if (bl) {
            hapPairs = new RevHapPairs(hapPairs);
        }
        float[] fArray = currentData.weights().get(hapPairs);
        Dag dag = this.makeDag(hapPairs, fArray, this.par.modelscale());
        this.runStats.setDagStats(dag);
        return dag;
    }

    private Dag makeDag(HapPairs hapPairs, float[] fArray, float f) {
        long l = System.nanoTime();
        int n = 500;
        Dag dag = MergeableDag.dag(hapPairs, fArray, f, n);
        this.runStats.buildNanos(System.nanoTime() - l);
        return dag;
    }

    private void sample(Dag dag, GL gL, boolean bl, int n, List<HapPair> list, int n2) {
        int n3;
        long l = System.nanoTime();
        Random random = new Random(this.par.seed());
        ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(3 * n2);
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            SingleBaum singleBaum = new SingleBaum(dag, gL, random.nextLong(), n, this.par.lowmem());
            executorService.submit(new ConsumeSingleSamples(bl, singleBaum, arrayBlockingQueue, list));
        }
        try {
            int n4 = gL.nSamples();
            for (n3 = 0; n3 < n4; ++n3) {
                arrayBlockingQueue.put(n3);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                arrayBlockingQueue.put(ConsumeSingleSamples.POISON);
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
        this.runStats.sampleNanos(System.nanoTime() - l);
    }

    private void sample(Dag dag, GL gL, boolean bl, int n, List<HapPair> list, GenotypeValues genotypeValues, int n2) {
        int n3;
        long l = System.nanoTime();
        Random random = new Random(this.par.seed());
        ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(3 * n2);
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            SingleBaum singleBaum = new SingleBaum(dag, gL, random.nextLong(), n, this.par.lowmem());
            executorService.submit(new ConsumeSingleSamples(bl, singleBaum, arrayBlockingQueue, list, genotypeValues));
        }
        try {
            int n4 = gL.nSamples();
            for (n3 = 0; n3 < n4; ++n3) {
                arrayBlockingQueue.put(n3);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                arrayBlockingQueue.put(ConsumeSingleSamples.POISON);
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
        this.runStats.sampleNanos(System.nanoTime() - l);
    }
}

