/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.Codons;
import dr.evolution.datatype.GeneticCode;
import dr.evolution.datatype.HiddenDataType;

public class HiddenCodons
extends Codons
implements HiddenDataType {
    public static final String DESCRIPTION = "hiddenCodon";
    public static final HiddenCodons UNIVERSAL_HIDDEN_2 = new HiddenCodons(GeneticCode.UNIVERSAL, 2);
    public static final HiddenCodons UNIVERSAL_HIDDEN_3 = new HiddenCodons(GeneticCode.UNIVERSAL, 3);
    public static final HiddenCodons UNIVERSAL_HIDDEN_4 = new HiddenCodons(GeneticCode.UNIVERSAL, 4);
    public static final HiddenCodons UNIVERSAL_HIDDEN_5 = new HiddenCodons(GeneticCode.UNIVERSAL, 5);
    private int hiddenClassCount;

    private HiddenCodons(GeneticCode geneticCode, int n) {
        super(geneticCode);
        this.hiddenClassCount = n;
    }

    @Override
    public boolean[] getStateSet(int n) {
        boolean[] blArray = new boolean[this.stateCount * this.hiddenClassCount];
        if (!this.isAmbiguousState(n)) {
            for (int i = 0; i < this.hiddenClassCount; ++i) {
                blArray[i * this.stateCount + n] = true;
            }
        } else {
            for (int i = 0; i < this.stateCount; ++i) {
                blArray[i] = true;
            }
        }
        return blArray;
    }

    @Override
    public String getTriplet(int n2) {
        return HiddenDataType.getCodeImpl(n2, this.stateCount, n -> super.getTriplet((int)n));
    }

    public String getTripletWithoutHiddenCode(int n2) {
        return HiddenDataType.getCodeWithoutHiddenStateImpl(n2, this.stateCount, n -> super.getTriplet((int)n));
    }

    @Override
    public String getCode(int n2) {
        return HiddenDataType.getCodeImpl(n2, this.stateCount, n -> super.getCode((int)n));
    }

    @Override
    public String getCodeWithoutHiddenState(int n2) {
        return HiddenDataType.getCodeWithoutHiddenStateImpl(n2, this.stateCount, n -> super.getCode((int)n));
    }

    @Override
    public int getStateCount() {
        return this.stateCount * this.hiddenClassCount;
    }

    @Override
    public int getHiddenClassCount() {
        return this.hiddenClassCount;
    }
}

