/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.MSSD;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.MSSD.AbstractObservationProcess;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;

public class AnyTipObservationProcess
extends AbstractObservationProcess {
    protected double[] u0;
    protected double[] p;
    private int[] extantInTips;
    private int[] extantInTipsBelow;
    private int[] postOrderNodeList;

    public AnyTipObservationProcess(String string, TreeModel treeModel, PatternList patternList, SiteRateModel siteRateModel, BranchRateModel branchRateModel, Parameter parameter, Parameter parameter2) {
        super(string, treeModel, patternList, siteRateModel, branchRateModel, parameter, parameter2);
    }

    @Override
    public double calculateLogTreeWeight() {
        int n;
        int n2 = this.treeModel.getNodeCount();
        if (this.u0 == null || this.p == null) {
            this.u0 = new double[n2];
            this.p = new double[n2];
        }
        double d = 0.0;
        double d2 = this.getAverageRate();
        for (n = 0; n < n2; ++n) {
            this.p[n] = 1.0 - this.getNodeSurvivalProbability(n, d2);
        }
        TreeUtils.postOrderTraversalList(this.treeModel, this.postOrderNodeList);
        for (int i = 0; i < this.nodeCount; ++i) {
            n = this.postOrderNodeList[i];
            if (n < this.treeModel.getExternalNodeCount()) {
                this.u0[n] = 0.0;
                d += 1.0 - this.p[n];
                continue;
            }
            this.u0[n] = 1.0;
            NodeRef nodeRef = this.treeModel.getNode(n);
            for (int j = 0; j < this.treeModel.getChildCount(nodeRef); ++j) {
                int n3 = this.treeModel.getChild(nodeRef, j).getNumber();
                int n4 = n;
                this.u0[n4] = this.u0[n4] * (1.0 - this.p[n3] * (1.0 - this.u0[n3]));
            }
            d += (1.0 - this.u0[n]) * (1.0 - this.p[n]);
        }
        return -d * this.lam.getParameterValue(0) / (this.getAverageRate() * this.mu.getParameterValue(0));
    }

    private void setTipNodePatternInclusion() {
        int n;
        for (n = 0; n < this.treeModel.getExternalNodeCount(); ++n) {
            NodeRef nodeRef = this.treeModel.getNode(n);
            for (int i = 0; i < this.patternCount; ++i) {
                int[] nArray;
                this.extantInTipsBelow[n * this.patternCount + i] = 1;
                int n2 = this.patterns.getTaxonIndex(this.treeModel.getNodeTaxon(nodeRef));
                for (int n3 : nArray = this.dataType.getStates(this.patterns.getPatternState(n2, i))) {
                    if (n3 != this.deathState) continue;
                    this.extantInTipsBelow[n * this.patternCount + i] = 0;
                }
                int n4 = i;
                this.extantInTips[n4] = this.extantInTips[n4] + this.extantInTipsBelow[n * this.patternCount + i];
            }
        }
        for (n = 0; n < this.treeModel.getExternalNodeCount(); ++n) {
            for (int i = 0; i < this.patternCount; ++i) {
                this.nodePatternInclusion[n * this.patternCount + i] = this.extantInTipsBelow[n * this.patternCount + i] >= this.extantInTips[i];
            }
        }
    }

    @Override
    void setNodePatternInclusion() {
        int n;
        if (this.postOrderNodeList == null) {
            this.postOrderNodeList = new int[this.nodeCount];
        }
        if (this.nodePatternInclusion == null) {
            this.nodePatternInclusion = new boolean[this.nodeCount * this.patternCount];
            this.storedNodePatternInclusion = new boolean[this.nodeCount * this.patternCount];
        }
        if (this.extantInTips == null) {
            this.extantInTips = new int[this.patternCount];
            this.extantInTipsBelow = new int[this.nodeCount * this.patternCount];
            this.setTipNodePatternInclusion();
        }
        TreeUtils.postOrderTraversalList(this.treeModel, this.postOrderNodeList);
        for (n = 0; n < this.nodeCount; ++n) {
            NodeRef nodeRef = this.treeModel.getNode(this.postOrderNodeList[n]);
            int n2 = this.treeModel.getChildCount(nodeRef);
            if (n2 <= 0) continue;
            int n3 = nodeRef.getNumber();
            for (int i = 0; i < this.patternCount; ++i) {
                this.extantInTipsBelow[n3 * this.patternCount + i] = 0;
                for (int j = 0; j < n2; ++j) {
                    int n4 = this.treeModel.getChild(nodeRef, j).getNumber();
                    int n5 = n3 * this.patternCount + i;
                    this.extantInTipsBelow[n5] = this.extantInTipsBelow[n5] + this.extantInTipsBelow[n4 * this.patternCount + i];
                }
            }
        }
        for (n = this.treeModel.getExternalNodeCount(); n < this.treeModel.getNodeCount(); ++n) {
            for (int i = 0; i < this.patternCount; ++i) {
                this.nodePatternInclusion[n * this.patternCount + i] = this.extantInTipsBelow[n * this.patternCount + i] >= this.extantInTips[i];
            }
        }
        this.nodePatternInclusionKnown = true;
    }
}

