/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MathUtils;

public class Poisson {
    private static double oldm = -1.0;
    private static double sq;
    private static double alxm;
    private static double g;
    private static final double[] cof;

    private Poisson() {
    }

    public static int nextPoisson(double d) {
        double d2;
        if (d < 12.0) {
            if (d != oldm) {
                oldm = d;
                g = Math.exp(-d);
            }
            d2 = -1.0;
            double d3 = 1.0;
            do {
                d2 += 1.0;
            } while ((d3 *= MathUtils.nextDouble()) > g);
        } else {
            if (d != oldm) {
                oldm = d;
                sq = Math.sqrt(2.0 * d);
                alxm = Math.log(d);
                g = d * alxm - Poisson.gammln(d + 1.0);
            }
            while (true) {
                double d4;
                if ((d2 = sq * (d4 = Math.tan(Math.PI * MathUtils.nextDouble())) + d) < 0.0) {
                    continue;
                }
                d2 = Math.floor(d2);
                double d5 = 0.9 * (1.0 + d4 * d4) * Math.exp(d2 * alxm - Poisson.gammln(d2 + 1.0) - g);
                if (!(MathUtils.nextDouble() > d5)) break;
            }
        }
        return (int)d2;
    }

    public static double gammln(double d) {
        double d2;
        double d3 = d2 = d;
        double d4 = d2 + 5.5;
        d4 -= (d2 + 0.5) * Math.log(d4);
        double d5 = 1.000000000190015;
        for (int i = 0; i <= 5; ++i) {
            d5 += cof[i] / (d3 += 1.0);
        }
        return -d4 + Math.log(2.5066282746310007 * d5 / d2);
    }

    static {
        cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    }
}

