/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangDenseMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class LowerTriangDenseMatrix
extends AbstractTriangDenseMatrix {
    public LowerTriangDenseMatrix(int n) {
        super(n, BLASkernel.UpLo.Lower, BLASkernel.Diag.NonUnit);
    }

    LowerTriangDenseMatrix(int n, BLASkernel.Diag diag) {
        super(n, BLASkernel.UpLo.Lower, diag);
    }

    public LowerTriangDenseMatrix(Matrix A) {
        this(A, Math.min(A.numRows(), A.numColumns()));
    }

    public LowerTriangDenseMatrix(Matrix A, boolean deep) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep);
    }

    LowerTriangDenseMatrix(Matrix A, boolean deep, BLASkernel.Diag diag) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep, diag);
    }

    public LowerTriangDenseMatrix(Matrix A, int k) {
        this(A, k, true);
    }

    public LowerTriangDenseMatrix(Matrix A, int k, boolean deep) {
        super(A, k, deep, BLASkernel.UpLo.Lower, BLASkernel.Diag.NonUnit);
    }

    LowerTriangDenseMatrix(Matrix A, int k, boolean deep, BLASkernel.Diag diag) {
        super(A, k, deep, BLASkernel.UpLo.Lower, diag);
    }

    public void add(int row, int column, double value) {
        if (column > row) {
            throw new IllegalArgumentException("column > row");
        }
        super.add(row, column, value);
    }

    public double get(int row, int column) {
        if (column > row) {
            return 0.0;
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (column > row) {
            throw new IllegalArgumentException("column > row");
        }
        super.set(row, column, value);
    }

    public LowerTriangDenseMatrix copy() {
        return new LowerTriangDenseMatrix(this);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() < e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }
}

