/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumbers
extends JComponent
implements AdjustmentListener {
    private static final long serialVersionUID = -2196475189826669853L;
    private Dimension d = new Dimension();
    private boolean showing = true;
    private int BAR = 4;
    private JTextComponent src;
    private JScrollPane scroller;
    private Dimension sizeCache = new Dimension();
    private Point locCache = new Point();

    public LineNumbers(JTextComponent src, JScrollPane scroller) {
        this.src = src;
        this.scroller = scroller;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LineNumbers.this.showing) {
                    LineNumbers.this.hideBar();
                } else {
                    LineNumbers.this.showBar();
                }
            }
        });
        scroller.getVerticalScrollBar().addAdjustmentListener(this);
        super.setFont(src.getFont());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        this.scroller.validate();
    }

    private void hideBar() {
        this.showing = false;
        this.scroller.setRowHeaderView(this);
    }

    private void showBar() {
        this.showing = true;
        this.scroller.setRowHeaderView(this);
    }

    private void paintNumbers(Graphics g) {
        g.setColor(UIManager.getColor("InternalFrame.activeTitleBackground"));
        Rectangle r = g.getClipBounds();
        Insets insets = this.getBorder().getBorderInsets(this);
        r.width -= insets.right + insets.left;
        r.x += insets.left;
        ((Graphics2D)g).fill(r);
        int ascent = this.getFontMetrics(this.getFont()).getAscent();
        int h = this.getFontMetrics(this.getFont()).getHeight();
        int y = (int)(r.getY() / (double)h) * h;
        int max = (int)(r.getY() + r.getHeight()) / h;
        g.setColor(UIManager.getColor("Label.foreground"));
        for (int i = (int)Math.floor(y / h) + 1; i <= max + 1; ++i) {
            g.drawString(i + "", insets.left, y + ascent);
            y += h;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.d.width = this.getMyWidth();
        this.d.height = this.src.getHeight();
        return this.d;
    }

    public int getLineCount() {
        Element map = this.src.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    private int getMyWidth() {
        FontMetrics fm = this.src.getFontMetrics(this.src.getFont());
        return this.showing ? fm.stringWidth(this.getVisibleEndLine() + "") + 4 + this.BAR : this.BAR;
    }

    public int getVisibleStartLine() {
        this.scroller.getViewport().getView().getLocation(this.locCache);
        int h = this.getFontMetrics(this.getFont()).getHeight();
        int y = (int)(this.locCache.getY() / (double)h) * h;
        return (int)Math.floor(y / h) + 1;
    }

    public int getVisibleEndLine() {
        this.scroller.getViewport().getView().getLocation(this.locCache);
        this.scroller.getViewport().getSize(this.sizeCache);
        int h = this.getFontMetrics(this.getFont()).getHeight();
        return (int)Math.abs(-this.locCache.getY() + this.sizeCache.getHeight()) / h;
    }

    @Override
    public void paint(Graphics g) {
        this.getBorder().paintBorder(this, g, 0, 0, this.d.width, this.d.height + 1);
        if (this.showing) {
            this.paintNumbers(g);
        }
    }
}

