/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.Serializable;

public class SMOset
implements Serializable {
    private int m_number;
    private int m_first;
    private boolean[] m_indicators;
    private int[] m_next;
    private int[] m_previous;

    public SMOset(int n) {
        this.m_indicators = new boolean[n];
        this.m_next = new int[n];
        this.m_previous = new int[n];
        this.m_number = 0;
        this.m_first = -1;
    }

    public boolean contains(int n) {
        return this.m_indicators[n];
    }

    public void delete(int n) {
        if (this.m_indicators[n]) {
            if (this.m_first == n) {
                this.m_first = this.m_next[n];
            } else {
                this.m_next[this.m_previous[n]] = this.m_next[n];
            }
            if (this.m_next[n] != -1) {
                this.m_previous[this.m_next[n]] = this.m_previous[n];
            }
            this.m_indicators[n] = false;
            --this.m_number;
        }
    }

    public void insert(int n) {
        if (!this.m_indicators[n]) {
            if (this.m_number == 0) {
                this.m_first = n;
                this.m_next[n] = -1;
                this.m_previous[n] = -1;
            } else {
                this.m_previous[this.m_first] = n;
                this.m_next[n] = this.m_first;
                this.m_previous[n] = -1;
                this.m_first = n;
            }
            this.m_indicators[n] = true;
            ++this.m_number;
        }
    }

    public int getNext(int n) {
        if (n == -1) {
            return this.m_first;
        }
        return this.m_next[n];
    }

    public void printElements() {
        int n = this.getNext(-1);
        while (n != -1) {
            System.err.print(n + " ");
            n = this.getNext(n);
        }
        System.err.println();
        for (n = 0; n < this.m_indicators.length; ++n) {
            if (!this.m_indicators[n]) continue;
            System.err.print(n + " ");
        }
        System.err.println();
        System.err.println(this.m_number);
    }

    public int numElements() {
        return this.m_number;
    }
}

