/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.FPgrowthProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.parseParameters;

public class FPgrowth {
    private myDataset trans;
    private String rulesFilename;
    private String valuesFilename;
    private FPgrowthProcess proc;
    private ArrayList<AssociationRule> associationRules;
    private int nPartitionForNumericAttributes;
    private double minSupport;
    private double minConfidence;
    private boolean somethingWrong = false;

    public FPgrowth() {
    }

    public FPgrowth(parseParameters parameters) {
        this.rulesFilename = parameters.getAssociationRulesFile();
        this.valuesFilename = parameters.getOutputFile(0);
        this.nPartitionForNumericAttributes = Integer.parseInt(parameters.getParameter(0));
        try {
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans = new myDataset(this.nPartitionForNumericAttributes);
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.minSupport = Double.parseDouble(parameters.getParameter(1));
        this.minConfidence = Double.parseDouble(parameters.getParameter(2));
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.proc = new FPgrowthProcess(this.trans, this.minSupport, this.minConfidence);
            this.proc.run();
            this.associationRules = this.proc.generateRulesSet();
            this.proc.printReport(this.associationRules);
            try {
                double[] step_values = this.trans.getSteps();
                ArrayList<Integer> id_attr_values = this.trans.getIDsOfAllAttributeValues();
                PrintWriter rules_writer = new PrintWriter(this.rulesFilename);
                PrintWriter values_writer = new PrintWriter(this.valuesFilename);
                rules_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rules_writer.println("<rules>");
                values_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                values_writer.println("<values>");
                for (int r = 0; r < this.associationRules.size(); ++r) {
                    int i;
                    AssociationRule a_r = this.associationRules.get(r);
                    rules_writer.println("<rule id=\"" + r + "\">");
                    values_writer.println("<rule id=\"" + r + "\" rule_support=\"" + a_r.getRuleSupport() + "\" antecedent_support=\"" + a_r.getAntecedentSupport() + "\" consequent_support=\"" + a_r.getConsequentSupport() + "\" confidence=\"" + a_r.getConfidence() + "\"/>");
                    rules_writer.println("<antecedents>");
                    short[] terms = a_r.getAntecedent();
                    for (i = 0; i < terms.length; ++i) {
                        this.createRule(id_attr_values.get(terms[i] - 1), step_values, rules_writer);
                    }
                    rules_writer.println("</antecedents>");
                    rules_writer.println("<consequents>");
                    terms = a_r.getConsequent();
                    for (i = 0; i < terms.length; ++i) {
                        this.createRule(id_attr_values.get(terms[i] - 1), step_values, rules_writer);
                    }
                    rules_writer.println("</consequents>");
                    rules_writer.println("</rule>");
                }
                rules_writer.println("</rules>");
                values_writer.println("</values>");
                rules_writer.close();
                values_writer.close();
                System.out.println("\nAlgorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void createRule(int fake_value, double[] step_values, PrintWriter w) {
        int id_attr = fake_value % this.trans.getnVars();
        int true_value = (fake_value - id_attr) / this.trans.getnVars();
        w.print("<attribute name=\"" + this.trans.getAttributeName(id_attr) + "\" value=\"");
        if (this.trans.getAttributeType(id_attr) == 0) {
            w.print(this.trans.getNominalValue(id_attr, true_value));
        } else {
            w.print("[" + (this.trans.getMin(id_attr) + step_values[id_attr] * (double)true_value) + ", " + (this.trans.getMin(id_attr) + step_values[id_attr] * (double)(true_value + 1)) + "]");
        }
        w.println("\"/>");
    }
}

