/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.CART.impurities;

import keel.Algorithms.Decision_Trees.CART.impurities.IImpurityFunction;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;

public class LeastSquaresDeviation
implements IImpurityFunction {
    private DoubleTransposedDataSet dataset;

    @Override
    public void setDataset(DoubleTransposedDataSet dataset) {
        this.dataset = dataset;
    }

    @Override
    public double impurities(int[] patterns, double cost) throws Exception {
        int nofpatterns = patterns.length;
        if (this.dataset.getNofoutputs() > 1) {
            throw new Exception("Illegal number of outputs for a regression method");
        }
        double[] outputs = this.dataset.getOutput(0);
        double mean = this.computeMean(patterns);
        double impurities = 0.0;
        for (int i = 0; i < patterns.length; ++i) {
            int patternIndex = patterns[i];
            impurities += Math.pow(outputs[patternIndex] - mean, 2.0);
        }
        return impurities;
    }

    private double computeMean(int[] patterns) {
        double mean = 0.0;
        double[] outputs = this.dataset.getOutput(0);
        for (int i = 0; i < patterns.length; ++i) {
            int patternIndex = patterns[i];
            mean += outputs[patternIndex];
        }
        return mean /= (double)patterns.length;
    }
}

